#ifndef IMAGEBUTTON_H
#define IMAGEBUTTON_H

///*********************************************************************************///
///							ImageButton.h											///
///																					///
///	Purpose: This class extends CButton to allow for transparent image display on 	///
///				button faces.                                                		///
///																					///
///*********************************************************************************///

class CImageButton : public CButton
{
// Construction
public:
	CImageButton();
	virtual ~CImageButton();

// Methods
public:
    void SetImageList(const CString &strFileName, bool bUpdate = true);
	void LoadBitmap(int iResId);
    BOOL HitTest();

// Variables
protected:

	// Imagelist for button facing
	CImageList *m_pImageList;

	// True if mouse is in the button's area
	BOOL m_bInControl;

	// Region for button size
	CRgn m_rgn;
HRGN CreateRegionFromMask(HBITMAP hImage, int x, int y, COLORREF crColor, BOOL bColorFromPoint) ;


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CImageButton)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	//}}AFX_VIRTUAL

	// Generated message map functions
protected:
	//{{AFX_MSG(CImageButton)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif