///*********************************************************************************///
///							ImageButton.cpp											///
///																					///
///	Purpose: This class extends CButton to allow for transparent image display on 	///
///				button faces.                                                       ///
///																				    ///
///*********************************************************************************///


#include "stdafx.h"
#include "resource.h"
#include "ImageButton.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define BTN_TIMER 5

CImageButton::CImageButton()
{
	// Initialization
	m_pImageList = NULL;
    m_bInControl = FALSE;
}

CImageButton::~CImageButton()
{
    m_bInControl = FALSE;
    if (m_pImageList != NULL)
    {
        delete m_pImageList;
        m_pImageList = NULL;
    }
}


BEGIN_MESSAGE_MAP(CImageButton, CButton)
//{{AFX_MSG_MAP(CImageButton)
ON_WM_MOUSEMOVE()
ON_WM_TIMER()
ON_WM_DESTROY()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImageButton message handlers

void CImageButton::OnMouseMove(UINT nFlags, CPoint point)
{
    TRACE0("OnMouseMove()\n");

    if (!m_bInControl)
    {
        m_bInControl = TRUE;
        SetTimer(BTN_TIMER, 20, NULL);
        TRACE0("SetTimer()\n");
        Invalidate();
    }

    CButton::OnMouseMove(nFlags, point);
}

void CImageButton::DrawItem(LPDRAWITEMSTRUCT lpDS)
{
    if (m_pImageList == NULL)
        CButton::DrawItem(lpDS);

	if( m_pImageList->m_hImageList == NULL || lpDS->hDC == NULL )
		return;

    CDC dc;
    dc.Attach(lpDS->hDC);
	dc.SetBkMode(TRANSPARENT);

    // Choose which image to draw
    if (lpDS->itemState & ODS_SELECTED) // button down
        m_pImageList->Draw(&dc, 1, CPoint(0, 0), ILD_TRANSPARENT);
    else if (m_bInControl == TRUE)      // mouse over
        m_pImageList->Draw(&dc, 2, CPoint(0, 0), ILD_TRANSPARENT);
    else if (lpDS->itemState & ODS_FOCUS) // focus
        m_pImageList->Draw(&dc, 0, CPoint(0, 0), ILD_TRANSPARENT);
    else if (lpDS->itemState & ODS_DISABLED) // Disabled
        m_pImageList->Draw(&dc, 0, CPoint(0, 0), ILD_TRANSPARENT);
    else if (lpDS->itemState & ODS_DEFAULT) // default
        m_pImageList->Draw(&dc, 0, CPoint(0, 0), ILD_TRANSPARENT);
    else                                  // normal
        m_pImageList->Draw(&dc, 0, CPoint(0, 0), ILD_TRANSPARENT);
}

void CImageButton::OnTimer(UINT nIDEvent)
{
	// Button timer used to redraw control
    if (nIDEvent == BTN_TIMER)
    {
        if (HitTest() == TRUE)
            TRACE0("HitTest returned TRUE\n");
        else
        {
            TRACE0("HitTest returned FALSE\n");
            m_bInControl = FALSE;
            KillTimer(BTN_TIMER);
            TRACE0("KilledTimer\n");
            Invalidate();
			RedrawWindow();
        }
    }
    else
        CButton::OnTimer(nIDEvent);
}

BOOL CImageButton::HitTest()
{
	// Test to see if we are over the button


    // Get mouse pos
    CRect rect;
    CPoint point;
	CRgn rgn;

    ::GetCursorPos(&point); // in screen coords
	return WindowFromPoint(point)->m_hWnd == m_hWnd;
}


void CImageButton::OnDestroy()
{
    CButton::OnDestroy();
    KillTimer(BTN_TIMER);
}

////////////////////////////////////////////////////////////////////////////////
// SetImageList()
////////////////////////////////////////////////////////////////////////////////
// This function calls sets the image list with four button states
//
////////////////////////////////////////////////////////////////////////////////
// PARAMETERS:	const CString &strFile - Path and filename of image to load
//
//				bool bUpdate - TRUE if the imagelist is being updated instead
//					of initially set
////////////////////////////////////////////////////////////////////////////////
// RETURN VALUES: NONE
////////////////////////////////////////////////////////////////////////////////
void CImageButton::SetImageList(const CString &strFile, bool bUpdate /*= false*/)
{
	if (bUpdate == true && m_pImageList)
	{
        delete m_pImageList;
        m_pImageList = NULL;
	}

//	LoadBitmap(strFile);
	ModifyStyle(0, BS_OWNERDRAW);
}

////////////////////////////////////////////////////////////////////////////////
// LoadBitmap()
////////////////////////////////////////////////////////////////////////////////
// This function attaches the bitmap to the imagelist
//
////////////////////////////////////////////////////////////////////////////////
// PARAMETERS:	const CString &strFile - Path and filename of image to load
//
////////////////////////////////////////////////////////////////////////////////
// RETURN VALUES: NONE
////////////////////////////////////////////////////////////////////////////////
void CImageButton::LoadBitmap(int iResId)
{
    HIMAGELIST hImage;
    HBITMAP hBitmap;
    BITMAP section;

    if (m_pImageList != NULL)
        return;

    m_pImageList = new CImageList();
  //  hBitmap = (HBITMAP)::LoadImage(GetModuleHandle(NULL), strFile, IMAGE_BITMAP, 0, 0, 0 );
    hBitmap = (HBITMAP) LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(iResId),
                              IMAGE_BITMAP, 284, 30, 0L);

	if( hBitmap )
	{
		::GetObject(hBitmap, sizeof(BITMAP), &section);
		hImage = ImageList_Create(section.bmWidth / 4, section.bmHeight, ILC_COLOR16 | ILC_MASK, 0, 4);
		ImageList_AddMasked(hImage, hBitmap, RGB(255, 0, 0));

		SetWindowPos(NULL, 0, 0, section.bmWidth / 4, section.bmHeight, SWP_NOMOVE | SWP_NOZORDER);

		DeleteObject(hBitmap);
		m_pImageList->Attach(hImage);

		CRgn rgn;
		IMAGEINFO info;
		m_pImageList->GetImageInfo(0, &info);
		m_rgn.Attach(CreateRegionFromMask(info.hbmMask, 0, 0, RGB(255, 255, 255), FALSE));
		SetWindowRgn(m_rgn, TRUE);
 	}
}

HRGN CImageButton::CreateRegionFromMask(HBITMAP hImage, int x, int y, COLORREF crColor, BOOL bColorFromPoint)
{
	HDC hDC, hMemDC;
	BITMAP bm;
	POINT pt;
	BOOL bFirstTime = TRUE;
	POINT pStartPt, pLastPt, tpt;
	int x4[4] = {0,1,0,-1};
	int y4[4] = {-1,0,1,0};
	int iCameFrom, i;
	BOOL bTouched = FALSE;
	POINT pExtra;
	HRGN  hOutRgn;

	hDC = ::GetDC(m_hWnd);

	GetObject(hImage, sizeof(BITMAP), (LPSTR)&bm);

	pt.x = bm.bmWidth;
	pt.y = bm.bmHeight;

	hMemDC = CreateCompatibleDC(hDC);
	SelectObject(hMemDC, hImage);

	if (bColorFromPoint)
	{
		crColor = GetPixel(hMemDC, x, y);
	}

	bFirstTime = TRUE;

	BeginPath(hDC);

	pStartPt.x = -1;
	pStartPt.y = 0;
	pLastPt.x = -1;
	pLastPt.y = 0;


	for (tpt.y = 0; tpt.y < pt.y; tpt.y++)
	{
		for (tpt.x = 0; tpt.x < pt.x; tpt.x++)
		{
			if (GetPixel(hMemDC, tpt.x, tpt.y) != crColor)
			{
				pStartPt = tpt;
				MoveToEx(hDC, tpt.x, tpt.y, NULL);
				bFirstTime = FALSE;
				break;
			}
			pLastPt = tpt;
		}
		if (!bFirstTime)
			break;
	}

	tpt = pStartPt;

	while (1)
	{
		pExtra.x = 0; pExtra.y=0;
		bTouched = FALSE;
		//  First Check To See if it touches a transparent pixel
		for (i=0; i<4; i++)
		{
			if ((GetPixel(hMemDC, tpt.x+x4[i], tpt.y+y4[i]) == crColor) ||
				(tpt.x+x4[i] < 0) || (tpt.y+y4[i] < 0) || (tpt.x+x4[i] >= pt.x) || (tpt.y+y4[i] >= pt.y))
			{
				if (i == 1)
					pExtra.x = 1;
				if ((i == 2) && (pExtra.x != 1) )
					pExtra.y = 1;
				if (i==3)
					pExtra.y = 0;
				bTouched = TRUE;
			}
		}

		if (bTouched)
			LineTo(hDC, tpt.x+pExtra.x, tpt.y+pExtra.y);

		//  Where Did it come from?
		for (i = 0; i < 4; i++)
		{
			if ((pLastPt.x == tpt.x + x4[i])
				 && (pLastPt.y == tpt.y + y4[i]))
			{
				iCameFrom = i;  // 0 = 12, 1 = 3, 2=6, 3 =9
				break;
			}
		}

		for (i = 1; i < 5; i++)
        {
			if ((GetPixel(hMemDC, tpt.x + x4[(iCameFrom+i) % 4],
				          tpt.y + y4[(iCameFrom + i) % 4]) == crColor)
						  || (tpt.x + x4[(iCameFrom + i) % 4] < 0)
						  || (tpt.y + y4[(iCameFrom + i) % 4] < 0)
						  || (tpt.x + x4[(iCameFrom + i) % 4] >= pt.x)
						  || (tpt.y + y4[(iCameFrom + i) % 4] >= pt.y))
			{
				continue;
			}
			else
			{
				pLastPt = tpt;
				tpt.x += x4[(iCameFrom + i) % 4];
				tpt.y += y4[(iCameFrom + i) % 4];
				break;
			}
        }

		if ((tpt.x  == pStartPt.x) && (tpt.y == pStartPt.y))
		{
			LineTo(hDC, tpt.x, tpt.y);
			break;
		}
	}

	CloseFigure(hDC);
	EndPath(hDC);
	hOutRgn = PathToRegion(hDC);

	::ReleaseDC(m_hWnd,hDC);
	DeleteDC(hMemDC);

	return hOutRgn;
}