// AnimatedGifPlayerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AnimatedGifPlayer.h"
#include "AnimatedGifPlayerDlg.h"
#include "MyHyperLink.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CMyHyperLink	m_hyperlink;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
    m_hyperlink.SetLinkUrl("http://activex.moonvalley.com/");
    m_hyperlink.ActiveToolTip(1);
    m_hyperlink.SetTootTipText("Visit the Moon Valley ActiveX page.");
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_LINK, m_hyperlink);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimatedGifPlayerDlg dialog

CAnimatedGifPlayerDlg::CAnimatedGifPlayerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAnimatedGifPlayerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAnimatedGifPlayerDlg)
	m_file = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAnimatedGifPlayerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnimatedGifPlayerDlg)
	DDX_Control(pDX, IDC_MVSBUTTON, m_MVSButton);
	DDX_Control(pDX, IDC_BORDER, m_border);
	DDX_Control(pDX, IDC_ANIMATEDGIFCTRL1, m_animatedGif);
	DDX_Text(pDX, IDC_FILE, m_file);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAnimatedGifPlayerDlg, CDialog)
	//{{AFX_MSG_MAP(CAnimatedGifPlayerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_OPEN, OnOpen)
	ON_BN_CLICKED(IDC_PLAY, OnPlay)
	ON_BN_CLICKED(IDC_PLAY_ONCE, OnPlayOnce)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_BN_CLICKED(IDC_ABOUT_BOX, OnAboutBox)
	ON_EN_CHANGE(IDC_FILE, OnChangeFile)
	ON_BN_CLICKED(IDC_MVSBUTTON, OnMvsbutton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimatedGifPlayerDlg message handlers

BOOL CAnimatedGifPlayerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
    m_MVSButton.LoadBitmap(IDB_BITMAP1);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAnimatedGifPlayerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAnimatedGifPlayerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAnimatedGifPlayerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// This method is called when the user clicks the open button.
void CAnimatedGifPlayerDlg::OnOpen() 
{
	// create an open dialog
	CFileDialog obDlg(true, ".gif", NULL, OFN_EXPLORER | OFN_HIDEREADONLY, "GIF Files (*.gif)|*.gif|All Files (*.*)|*.*||", this);

    if (obDlg.DoModal() == IDOK)
	{
		m_file = obDlg.GetPathName(); // set the file name
		m_animatedGif.SetAnimatedGif(obDlg.GetPathName()); // open the file
		
		UpdateData(FALSE);
	}
	
}

// This method is called when the user clicks the play button.
void CAnimatedGifPlayerDlg::OnPlay() 
{
	m_animatedGif.Play(); // play the gif	
}

// This method is called when the user clicks the Play Once button
void CAnimatedGifPlayerDlg::OnPlayOnce() 
{
	m_animatedGif.PlayOnce(); // play the gif one time	
}

// This method is called when the user clicks the Stop button.
void CAnimatedGifPlayerDlg::OnStop() 
{
	m_animatedGif.Stop(); // stop the gif
	
}

// This method is called when the user clicks the About Box button.
void CAnimatedGifPlayerDlg::OnAboutBox() 
{
	m_animatedGif.AboutBox(); // display the about box
	
}

// This method is called whenever the File edit box changes
void CAnimatedGifPlayerDlg::OnChangeFile() 
{
	UpdateData();
	
	m_animatedGif.SetAnimatedGif(m_file); // set the animated gif
}

BEGIN_EVENTSINK_MAP(CAnimatedGifPlayerDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CAnimatedGifPlayerDlg)
	ON_EVENT(CAnimatedGifPlayerDlg, IDC_ANIMATEDGIFCTRL1, 4 /* LeftMouseDown */, OnLeftMouseDownAnimatedgifctrl1, VTS_NONE)
	ON_EVENT(CAnimatedGifPlayerDlg, IDC_ANIMATEDGIFCTRL1, 3 /* RightMouseDown */, OnRightMouseDownAnimatedgifctrl1, VTS_NONE)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()


// This is the event handler for the LeftMouseDown event on the Animated Gif control
void CAnimatedGifPlayerDlg::OnLeftMouseDownAnimatedgifctrl1() 
{
	// Treat the left mouse down like "Play"
	m_animatedGif.Play(); // play the gif
	
}

// This is the event handler for the RightMouseDown event on the Animated Gif control
void CAnimatedGifPlayerDlg::OnRightMouseDownAnimatedgifctrl1() 
{
	// Treat the right mouse down like "Stop"
	m_animatedGif.Stop(); // stop the gif
}

void CAnimatedGifPlayerDlg::OnMvsbutton() 
{
    // Executes an open command to the Moon Valley website.  The system's default
    // viewer for webpages will be initialized to view the page.
    ShellExecute(NULL, "open", "http://www.moonvalley.com/", "", NULL, SW_SHOWNORMAL);	
}
