package ssmith.opengl.shapes;

import ssmith.lang.Functions;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;

public class Sphere {

  public float x, y, z, radius;

  public Sphere(float x, float y, float z, float rad) {
    this.x = x;
    this.y = y;
    this.z = z;
    this.radius = rad;
  }
  
  public boolean intersects(Sphere other) {
      if (Functions.distance(this.x, this.y, this.z, other.x, other.y, other.z) <= (this.radius + other.radius)) {
          return true;
      } else {
          return false;
      }  
  }
  
  public void draw(GL gl, GLU glu) {
    gl.glTranslatef(x, y, z);
    glu.gluSphere(Canvas3D.quadratic, radius, 10, 10);

    // Move us back
    gl.glTranslatef(-x, -y, -z);
  }

}
