package ssmith.opengl.shapes;

import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;

public class Disc {

  private float x, y, z, inner_radius, outer_radius;
  private int angle;

  public Disc(float x, float y, float z, float inner_rad, float outer_rad, boolean horiz) {
    this(x, y, z, inner_rad, outer_rad, horiz == true ? 180 : 90);
  }

  public Disc(float x, float y, float z, float inner_rad, float outer_rad, int ang_from_horiz) {
    this.x = x;
    this.y = y;
    this.z = z;
    this.inner_radius = inner_rad;
    this.outer_radius = outer_rad;
    this.angle = ang_from_horiz;
  }

  public void draw(GL gl, GLU glu) {
    gl.glTranslatef(x, y, z);
    gl.glRotatef(angle, 1f, 0f, 0f);

    glu.gluDisk(Canvas3D.quadratic, inner_radius, outer_radius, 10, 1); // top

    // Move us back
    gl.glRotatef(-angle, 1f, 0f, 0f);
    gl.glTranslatef(-x, -y, -z);
  }

}
