package ssmith.opengl.shapes;

import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;

public class Cylinder {

  public float x, y, z, top_radius, bottom_radius, height;
  public int x_angle, slices;

  public Cylinder(float x, float y, float z, float top_rad, float h, int slices, boolean horiz) {
    this(x, y, z, top_rad, h, slices, horiz == true ? 180 : 90);
  }

  public Cylinder(float x, float y, float z, float top_rad, float h, int slices, int ang_from_horiz) {
      this(x, y, z, top_rad, h, slices, ang_from_horiz, top_rad);
  }
  
  public Cylinder(float x, float y, float z, float top_rad, float h, int slices, int ang_from_horiz, float bottom_rad) {
    this.x = x;
    this.y = y;
    this.z = z;
    this.top_radius = top_rad;
    this.bottom_radius = bottom_rad;
    this.height = h;
    this.slices = slices;
    this.x_angle = ang_from_horiz;
  }

  public void draw(GL gl, GLU glu) {
    gl.glTranslatef(x, y, z);
    gl.glRotatef(x_angle, 1f, 0f, 0f);

    glu.gluCylinder(Canvas3D.quadratic, top_radius, bottom_radius, height, slices, 1); // last one was 10

    gl.glRotatef(180, 1f, 0f, 0f); // So the front is facing out
    glu.gluDisk(Canvas3D.quadratic, 0, top_radius, slices, 1); // top
    gl.glRotatef(-180, 1f, 0f, 0f);

    gl.glTranslatef(0f, 0f, height);
    glu.gluDisk(Canvas3D.quadratic, 0, top_radius, slices, 1); // bottom
    gl.glTranslatef(0f, 0f, -height);

    // Move us back
    gl.glRotatef(-x_angle, 1f, 0f, 0f);
    gl.glTranslatef(-x, -y, -z);
  }

}
