package ssmith.opengl.shapes;

import net.java.games.jogl.*;

public class Cube {

	  private float x, y, z, height;
	  private float half_l, half_w, half_height;
	  private boolean show_bottom;

	  public Cube(float x, float y, float z, float size, boolean bottom) {
	    this(x, y, z, size, size, size, bottom);
	  }

	  public Cube(float x, float y, float z, float l, float w, float h, boolean bottom) {
	    this.x = x;
	    this.y = y;
	    this.z = z;

	    this.height = h;
	    
	    this.show_bottom = bottom;

	    half_w = w / 2;
	    half_l = l / 2;
	    half_height = height / 2;
	}

	  public void draw(GL gl, GLU glu) {
	    gl.glTranslatef(x, y, z);

	    gl.glBegin(GL.GL_QUADS);

	    // Front
	    gl.glTexCoord2f(0.0f, 0.0f);
	    gl.glVertex3f( -half_w, half_height, -half_l);
	    gl.glTexCoord2f(1.0f, 0.0f);
	    gl.glVertex3f(half_w, half_height, -half_l);
	    gl.glTexCoord2f(1.0f, 1.0f);
	    gl.glVertex3f(half_w, -half_height, -half_l);
	    gl.glTexCoord2f(0.0f, 1.0f);
	    gl.glVertex3f( -half_w, -half_height, -half_l);

	    // Right
	    gl.glTexCoord2f(0.0f, 0.0f);
	    gl.glVertex3f(half_w, half_height, -half_l);
	    gl.glTexCoord2f(1.0f, 0.0f);
	    gl.glVertex3f(half_w, half_height, half_l);
	    gl.glTexCoord2f(1.0f, 1.0f);
	    gl.glVertex3f(half_w, -half_height, half_l);
	    gl.glTexCoord2f(0.0f, 1.0f);
	    gl.glVertex3f(half_w, -half_height, -half_l);

	    // back
	    gl.glTexCoord2f(0.0f, 0.0f);
	    gl.glVertex3f(half_w, half_height, half_l);
	    gl.glTexCoord2f(1.0f, 0.0f);
	    gl.glVertex3f( -half_w, half_height, half_l);
	    gl.glTexCoord2f(1.0f, 1.0f);
	    gl.glVertex3f( -half_w, -half_height, half_l);
	    gl.glTexCoord2f(0.0f, 1.0f);
	    gl.glVertex3f(half_w, -half_height, half_l);

	    // Left
	    gl.glTexCoord2f(0.0f, 0.0f);
	    gl.glVertex3f( -half_w, half_height, half_l);
	    gl.glTexCoord2f(0.0f, 1.0f);
	    gl.glVertex3f( -half_w, half_height, -half_l);
	    gl.glTexCoord2f(1.0f, 1.0f);
	    gl.glVertex3f( -half_w, -half_height, -half_l);
	    gl.glTexCoord2f(1.0f, 0.0f);
	    gl.glVertex3f( -half_w, -half_height, half_l);

	    // Top
	    gl.glTexCoord2f(0.0f, 0.0f);
	    gl.glVertex3f( -half_w, half_height, -half_l);
	    gl.glTexCoord2f(1.0f, 0.0f);
	    gl.glVertex3f( -half_w, half_height, half_l);
	    gl.glTexCoord2f(1.0f, 1.0f);
	    gl.glVertex3f(half_w, half_height, half_l);
	    gl.glTexCoord2f(0.0f, 1.0f);
	    gl.glVertex3f(half_w, half_height, -half_l);
	    
	    // Bottom
	    if (show_bottom) {
		    gl.glTexCoord2f(0.0f, 0.0f);
		    gl.glVertex3f( -half_w, -half_height, -half_l);
		    gl.glTexCoord2f(1.0f, 0.0f);
		    gl.glVertex3f(half_w, -half_height, -half_l);
		    gl.glTexCoord2f(1.0f, 1.0f);
		    gl.glVertex3f(half_w, -half_height, half_l);
		    gl.glTexCoord2f(0.0f, 1.0f);
		    gl.glVertex3f( -half_w, -half_height, half_l);
	    }
	    
	    gl.glEnd();

	    gl.glTranslatef(-x, -y, -z);

	  }

	}
