package ssmith.opengl.shapes;

import ssmith.opengl.Canvas3D;
import net.java.games.jogl.*;

public class Cone {

  private float x, y, z, radius, height;
  private int angle;

  public Cone(float x, float y, float z, float rad, float h, boolean horiz) {
    this(x, y, z, rad, h, horiz == true ? 180 : 90);
  }

  public Cone(float x, float y, float z, float rad, float h, int ang_from_horiz) {
    this.x = x;
    this.y = y;
    this.z = z;
    this.radius = rad;
    this.height = h;
    this.angle = ang_from_horiz;
  }

  public void draw(GL gl, GLU glu) {
    gl.glTranslatef(x, y, z);
    gl.glRotatef(angle, 1f, 0f, 0f);

    glu.gluCylinder(Canvas3D.quadratic, radius, 0, height, 10, 1); // last one was 10

    gl.glRotatef(180, 1f, 0f, 0f); // So the front is facing out
    glu.gluDisk(Canvas3D.quadratic, 0, radius, 10, 1); // top
    gl.glRotatef(-180, 1f, 0f, 0f);

  /*  gl.glTranslatef(0f, 0f, height);
    glu.gluDisk(Canvas3D.quadratic, 0, radius, 10, 1); // bottom
    gl.glTranslatef(0f, 0f, -height);*/

    // Move us back
    gl.glRotatef(-angle, 1f, 0f, 0f);
    gl.glTranslatef(-x, -y, -z);
  }

}
