/*
 * Created on 25-Sep-2006
 *
 */
package ssmith.opengl.menu;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import ssmith.opengl.Canvas3D;
import java.awt.event.KeyEvent;

public class GLMenuToggle extends GLMenuItem {

    private boolean first_opt_selected;
    private String opt1, opt2;

    public GLMenuToggle(String text, String o1, String o2, boolean choose_first) {
        super(text, true);
        opt1 = o1;
        opt2 = o2;
        first_opt_selected = choose_first;
    }

    public void itemSelected() {
        first_opt_selected = !first_opt_selected;
    }

    public boolean isFirstSelected() {
        return this.first_opt_selected;
    }

    public void receivedChar(KeyEvent e) {
        if (e.getKeyCode() == KeyEvent.VK_LEFT || e.getKeyCode() == KeyEvent.VK_RIGHT) {
            this.itemSelected();
        }
    }

    public void draw(Canvas3D canvas, GL gl, GLU glu, int font, int x, int y) {
        if (this.isSelected()) {
            menu.setSelectedColour(gl);
        } else {
            menu.setDeselectedColour(gl);
        }
        String str = (this.isSelected() ? "> " : "") + menu_text + "  " + (first_opt_selected ? opt1 : opt2);
        canvas.writeString(gl, x, y, font, str);
    }

    public String getOptionSelected() {
        return (first_opt_selected ? opt1 : opt2);
    }

}
