package ssmith.opengl.menu;

import net.java.games.jogl.GL;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.GLU;
import java.awt.event.KeyEvent;

public class GLMenuText extends GLMenuItem {

    private StringBuffer text = new StringBuffer();

    public GLMenuText(String label) {
        super(label, true);
    }

    public void receivedChar(KeyEvent e) {
        if (e.getKeyCode() == 8) { // Delete
            text.deleteCharAt(text.length()-2);
        } else if (e.getKeyCode() >= 32) {
            text.append(e.getKeyChar());
        }/* else if (e.getKeyCode() >= KeyEvent.VK_0 && e.getKeyCode() <= KeyEvent.VK_9) {
            text.append(e.getKeyChar());
        } else {
        	System.out.println("Unknown char: " + e.getKeyCode());
        }*/
    }

    public void draw(Canvas3D canvas, GL gl, GLU glu, int font, int x, int y) {
        if (this.isSelected()) {
            menu.setSelectedColour(gl);
        } else {
            menu.setDeselectedColour(gl);
        }
        canvas.writeString(gl, x, y, font, (this.isSelected() ? "> " : "") + menu_text + " " + text.toString() + "_");
    }

    public void itemSelected() {
    }

    public String getText() {
        return text.toString();
    }

}
