/*
 * Created on 25-Sep-2006
 *
 */
package ssmith.opengl.menu;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import ssmith.opengl.Canvas3D;
import java.awt.event.KeyEvent;

public class GLMenuSlider extends GLMenuItem {

    private int min, max, current;

    public GLMenuSlider(String text, int min, int max, int start) {
        super(text, true);
        this.min = min;
        this.max = max;
        this.current = start;
    }

    public int getCurrentValue() {
        return current;
    }

    public void itemSelected() {
        // Do nothing
    }

    public void receivedChar(KeyEvent e) {
    if (e.getKeyCode() == KeyEvent.VK_LEFT) {
        current--;
        if (current < min) {
            current = min;
        }
    } else if (e.getKeyCode() == KeyEvent.VK_RIGHT) {
        current++;
        if (current > max) {
            current = max;
        }
    }
}

    public void draw(Canvas3D canvas, GL gl, GLU glu, int font, int x, int y) {
        if (this.isSelected()) {
            menu.setSelectedColour(gl);
        } else {
            menu.setDeselectedColour(gl);
        }
        canvas.writeString(gl, x, y, font, (this.isSelected() ? "> " : "") + menu_text + " " + current);
    }

}
