package ssmith.opengl.menu;

import ssmith.opengl.Canvas3D;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;

public class GLMenuSelect extends GLMenuItem {

	public GLMenuSelect(String text) {
		super(text, true);
	}

    public void itemSelected() {
        menu.menuItemSelected(this);
    }

	public void draw(Canvas3D canvas, GL gl, GLU glu, int font, int x, int y) {
		if (this.isSelected()) {
            menu.setSelectedColour(gl);
		} else {
            menu.setDeselectedColour(gl);
		}
		canvas.writeString(gl, x, y, font, (this.isSelected() ? "> " : "") + menu_text);
	}

}
