package ssmith.opengl.menu;

import java.awt.event.KeyEvent;
import java.util.ArrayList;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import ssmith.opengl.Canvas3D;

public class GLMenuMultiToggle extends GLMenuItem {

    private int option_selected = 0;
    private ArrayList options = new ArrayList();

    public GLMenuMultiToggle(String text) {
        super(text, true);
    }
    
    public void addOption(String text, boolean selected) {
    	options.add(text);
    	if (selected) {
    		this.option_selected = this.options.size()-1;
    	}
    }
    
    public int getSelectedOption() {
    	return this.option_selected;
    }

    public void itemSelected() {
        this.option_selected++;
        if (this.option_selected >= this.options.size()) {
        	this.option_selected = 0;
        }
    }

    public void receivedChar(KeyEvent e) {
        if (e.getKeyCode() == KeyEvent.VK_LEFT) {
            this.option_selected--;
            if (this.option_selected < 0) {
            	this.option_selected = this.options.size() - 1;
            }
        } else if (e.getKeyCode() == KeyEvent.VK_RIGHT) {
            this.itemSelected();
        }
    }

    public void draw(Canvas3D canvas, GL gl, GLU glu, int font, int x, int y) {
        if (this.isSelected()) {
            menu.setSelectedColour(gl);
        } else {
            menu.setDeselectedColour(gl);
        }
        if (this.option_selected >= 0 && this.option_selected < this.options.size()) {
        	String str = (this.isSelected() ? "> " : "") + menu_text + "  " + (String)options.get(this.option_selected);
        	canvas.writeString(gl, x, y, font, str);
        }
    }

}
