package ssmith.opengl.menu;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import ssmith.opengl.Canvas3D;
import java.awt.event.KeyEvent;

public abstract class GLMenuItem {

	public String menu_text;
    protected final boolean selectable;
    public GLMenu menu;
    public int font;

	public GLMenuItem(String text, boolean can_select) {
		super();
		this.menu_text = text;
		selectable = can_select;
	}

    protected boolean isSelected() {
        return this == menu.getCurrentMenuItem();
    }

    public void receivedChar(KeyEvent e) {
         // Override if required
 }

    public abstract void itemSelected();

	public abstract void draw(Canvas3D canvas, GL gl, GLU glu, int font, int x, int y);

}
