package ssmith.opengl.menu;

import java.util.Enumeration;
import java.util.Vector;
import ssmith.opengl.Canvas3D;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import java.awt.event.KeyEvent;

public abstract class GLMenu {

	private static final int MENU_LINE_SIZE = 30;
    private static final float DESELECT_MOD = 0.6f;

	private Vector menu_items = new Vector();
	protected Canvas3D canvas;
    private GLMenuItem current_item;
	private boolean default_item_selected = false;
    private int font;
    private float sr, sg, sb, dr, dg, db;

	public GLMenu(Canvas3D canv, int font, float r, float g, float b) {
		super();
		this.canvas = canv;
        this.font = font;
        sr = r;
        sg = g;
        sb = b;
        dr = r * DESELECT_MOD;
        dg = g * DESELECT_MOD;
        db = b * DESELECT_MOD;
	}

    public void setSelectedColour(GL gl) {
        gl.glColor3f(sr, sg, sb);
    }

    public void setDeselectedColour(GL gl) {
        gl.glColor3f(dr, dg, db);
    }

	public void addMenuItem(GLMenuItem item) {
		menu_items.add(item);
        item.menu = this;
        item.font = font;

		if (default_item_selected == false) {
			if (item.selectable) {
				//item.selected = true;
				default_item_selected = true;
				this.current_item = item;
			}
		}
	}

        public void nextItem() {
            int selected_item = menu_items.indexOf(current_item);
                while (true) {
                    selected_item++;
                    if (selected_item >= this.menu_items.size()) {
                        selected_item = 0;
                    }
                    current_item = (GLMenuItem)this.menu_items.get(selected_item);
                    if (current_item.selectable) {
                        break;
                    }
                }
        }

        public void prevItem() {
            int selected_item = menu_items.indexOf(current_item);
                while (true) {
                    selected_item--;
                    if (selected_item < 0) {
                        selected_item = menu_items.size() - 1;
                    }
                    current_item = (GLMenuItem)this.menu_items.get(selected_item);
                    if (current_item.selectable) {
                        break;
                    }
                }
        }

    protected abstract void menuItemSelected(GLMenuItem menu_item);

    public void receivedChar(KeyEvent e) {
     current_item.receivedChar(e);
    }

	protected GLMenuItem getCurrentMenuItem() {
		return current_item;
	}

	public void selectCurrentItem() {
		this.current_item.itemSelected();
	}
	
	public void highlightItem(int no) {
		GLMenuItem item = (GLMenuItem)this.menu_items.get(no);
		if (item.selectable) {
            current_item = (GLMenuItem)this.menu_items.get(no);
		}
		
	}

	public void draw(GL gl, GLU glu, int x) {
		canvas.startTextMode(gl, glu);
		Enumeration enumr = menu_items.elements();
		GLMenuItem opt;
		int y = (canvas.getHeight()/2) - ((menu_items.size() / 2) * MENU_LINE_SIZE);
		while (enumr.hasMoreElements()) {
			opt = (GLMenuItem) enumr.nextElement();
			opt.draw(canvas, gl, glu, font, x, y);
			y += MENU_LINE_SIZE;
		}

		canvas.finishTextMode(gl);
	}

	public boolean shouldBeDrawn() {
		return true;
	}

	public void setCurrentItem(GLMenuItem item) {
		this.current_item = item;
	}
	
	public int getIndexOfMenuItem(GLMenuItem item) {
		return this.menu_items.indexOf(item);
	}
}
