package ssmith.opengl;

import ssmith.lang.Functions;

public class Vector {

  public float x, y, z;

  public Vector() {
  }

  public Vector(float x, float y, float z) {
    this.x = x;
    this.y = y;
    this.z = z;
  }

  public Vector copyFrom(Vector v) {
    this.x = v.x;
    this.y = v.y;
    this.z = v.z;
    return this;
  }
  
  public boolean isWithin(Vector v, float dist) {
    return Functions.distance(this.x, this.y, this.z, v.x, v.y, v.z) <= dist;
  }

  public Vector add(Vector v) {
      this.x += v.x;
      this.y += v.y;
      this.z += v.z;
      return this;
  }
  
  public Vector subtract(Vector v) {
      this.x -= v.x;
      this.y -= v.y;
      this.z -= v.z;
      return this;
  }
  
  public void normalise(float amt) {
      float max = Math.max(Functions.mod(x), Functions.mod(y));
      max = Math.max(max, Functions.mod(z));
      
      x = (x/max) * amt;
      y = (y/max) * amt;
      z = (z/max) * amt;
  }
  
  /**
   * This is a bit crappy and needs re-writing.
   * @param v
   * @param speed
   */
  public void tendTowards(Vector v, float speed) {
    if (this.x != v.x) {
      if (ssmith.lang.Functions.mod(this.x -
                                    v.x) <
          speed) {
        this.x = v.x;
      }
      else {
        if (this.x > v.x) {
          this.x = this.x - speed;
        }
        else {
          this.x = this.x + speed;
        }
      }
    }

    if (this.y != v.y) {
      if (ssmith.lang.Functions.mod(this.y -
                                    v.y) <
          speed) {
        this.y = v.y;
      }
      else {
        if (this.y > v.y) {
          this.y = this.y - speed;
        }
        else {
          this.y = this.y + speed;
        }
      }
    }

    if (this.z != v.z) {
      if (ssmith.lang.Functions.mod(this.z -
                                    v.z) <
          speed) {
        this.z = v.z;
      }
      else {
        if (this.z > v.z) {
          this.z = this.z - speed;
        }
        else {
          this.z = this.z + speed;
        }
      }
    }
  }

}
