package ssmith.opengl;

import java.io.*;
import java.net.*;
import java.awt.image.*;
import net.java.games.jogl.*;
import net.java.games.jogl.util.*;
import java.nio.*;
import javax.imageio.*;

public abstract class Textures {

    public GL gl; // todo - make private
    private GLDrawable glDrawable;
    public final int[] textures;
    private String texture_dir;
    private int max_textures;

  public Textures(String tex_dir, int max_tex) {
  	this.max_textures = max_tex;
    this.texture_dir = tex_dir;
    textures = new int[max_textures];
  }

  public void setGL(GL gl, GLDrawable glDrawable) {
  	this.gl = gl;
  	this.glDrawable = glDrawable;
          gl.glGenTextures(max_textures, textures);
  }

  public abstract void loadTextures();  // Must be called after setGL()

  public void loadTexture(int no, String name) {
      try {
          if (name.length() > 0) {
              //System.out.println("Loading " + name);
              gl.glBindTexture(GL.GL_TEXTURE_2D, textures[no]);
              BufferedImage img = readPNGImage(texture_dir + name);
              makeRGBTexture(gl, glDrawable.getGLU(), img, GL.GL_TEXTURE_2D, false);
              gl.glTexParameteri(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER,
                                 GL.GL_LINEAR);
              gl.glTexParameteri(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER,
                                 GL.GL_LINEAR);
          }
      } catch (IOException ex) {
          System.err.println("Error loading texture " + name);
      }

  }

/*  private void createTexture(GL gl, GLDrawable glDrawable, int name, String filename) {
    gl.glBindTexture(GL.GL_TEXTURE_2D, textures[name]);
    BufferedImage img = readPNGImage(texture_dir + filename);
    makeRGBTexture(gl, glDrawable.getGLU(), img, GL.GL_TEXTURE_2D, false);
    gl.glTexParameteri(GL.GL_TEXTURE_2D,GL.GL_TEXTURE_MIN_FILTER,GL.GL_LINEAR);
    gl.glTexParameteri(GL.GL_TEXTURE_2D,GL.GL_TEXTURE_MAG_FILTER,GL.GL_LINEAR);
  }
*/
  private BufferedImage readPNGImage(String resourceName) throws IOException {
      URL url = getResource(resourceName);
      if (url == null) {
        throw new RuntimeException("Error reading resource " + resourceName);
      }
      BufferedImage img = ImageIO.read(url);
      java.awt.geom.AffineTransform tx = java.awt.geom.AffineTransform.getScaleInstance(1, -1);
      tx.translate(0, -img.getHeight(null));
      AffineTransformOp op = new AffineTransformOp(tx, AffineTransformOp.TYPE_NEAREST_NEIGHBOR);
      img = op.filter(img, null);
      return img;
  }

  /** Retrieve a URL resource from the jar.  If the resource is not found, then
   * the local disk is also checked.
   * @param filename Complete filename, including parent path
   * @return a URL object if resource is found, otherwise null.
   */
  private final static URL getResource(final String filename) {
    // Try to load resource from jar
    URL url = ClassLoader.getSystemResource(filename);
    // If not found in jar, then load from disk
    if (url == null)
    {
      try
      {
        url = new URL("file", "localhost", filename);
      }
      catch (Exception urlException){} // ignore
    }
    return url;
  }

  private void makeRGBTexture(GL gl, GLU glu, BufferedImage img, int target, boolean mipmapped) {
    ByteBuffer dest = null;
    switch (img.getType())
    {
      case BufferedImage.TYPE_3BYTE_BGR:
      case BufferedImage.TYPE_CUSTOM:
      {
        byte[] data = ((DataBufferByte) img.getRaster().getDataBuffer()).getData();
        dest = ByteBuffer.allocateDirect(data.length);
        dest.order(ByteOrder.nativeOrder());
        dest.put(data, 0, data.length);
        break;
      }
      case BufferedImage.TYPE_INT_RGB:
      {
        int[] data = ((DataBufferInt) img.getRaster().getDataBuffer()).getData();
        dest = ByteBuffer.allocateDirect(data.length * BufferUtils.SIZEOF_INT);
        dest.order(ByteOrder.nativeOrder());
        dest.asIntBuffer().put(data, 0, data.length);
        break;
      }
      default:
        throw new RuntimeException("Unsupported image type " + img.getType());
    }

    if (mipmapped) {
      glu.gluBuild2DMipmaps(target, GL.GL_RGB8, img.getWidth(), img.getHeight(), GL.GL_RGB, GL.GL_UNSIGNED_BYTE, dest);
    } else {
      gl.glTexImage2D(target, 0, GL.GL_RGB, img.getWidth(), img.getHeight(), 0, GL.GL_RGB, GL.GL_UNSIGNED_BYTE, dest);
    }
  }

}
