package ssmith.opengl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.java.games.jogl.GL;

public final class Model {

	private static int next_list_no = 1;
	  
    /** The identifier of the display list held for this model */
    private int listID;

    /**
     * Create a new OBJ model that will render the object data
     * specified in OpenGL
     *
     * @param data The data to be rendered for this model
     */
    public Model(ModelData data, GL gl, int list_no, IModelDrawer col_select) {
        // we're going to process the OBJ data and produce a display list
        // that will display the model. First we ask OpenGL to create
        // us a display list
        listID = gl.glGenLists(list_no);

        // next we start producing the contents of the list
        gl.glNewList(listID, GL.GL_COMPILE);

        if (col_select != null) {
            col_select.initGL(gl);
        }

        // cycle through all the faces in the model data
        // rendering a triangle for it
        gl.glBegin(GL.GL_TRIANGLES);
        //int faceCount = data.getFaceCount();

        for (int g=0;g<data.getGroupCount();g++) {
            //Canvas3D.SetRandomColour(gl);
            if (col_select != null) {
                if (!col_select.drawGroup(g)) {
                    continue;
                }
                col_select.setColourForGroup(gl, g);
            }
            for (int i = 0; i < data.getFaceCount(g); i++) {
                for (int v = 0; v < 3; v++) {
                    // a position, normal and texture coordinate
                    // for each vertex in the face

                    Tuple3 vert = data.getFace(g, i).getVertex(v);
                    Tuple3 norm = data.getFace(g, i).getNormal(v);
                    Tuple3 tex = data.getFace(g, i).getTexCoord(v);

                    gl.glNormal3f(norm.getX(), norm.getY(), norm.getZ());
                    gl.glTexCoord2f(tex.getX(), tex.getY());
                    gl.glVertex3f(vert.getX(), vert.getY(), vert.getZ());
                }
            }
        }
        gl.glEnd();
        gl.glEndList();
    }

    /**
     * Render the OBJ Model
     */
    public void render(GL gl) {
        // since we rendered our display list at construction we
        // can now just call this list causing it to be rendered
        // to the screen
        gl.glCallList(listID);
    }

    public static int getNextListNo() {
        return next_list_no++;
    }

    //-----------------------------------------------------

    public static Model LoadObj(String model_filename, GL gl, int list_no, float scale, IModelDrawer colour_sel) throws IOException {
        InputStream in = new FileInputStream(model_filename);// ObjLoader.class.getClassLoader().getResourceAsStream(ref);

        if (in == null) {
            throw new IOException("Unable to find: "+model_filename);
        }

        return new Model(new ModelData(in, scale), gl, list_no, colour_sel);
    }
}
