/*
 * Created on 03-Oct-2005
 *
 */
package ssmith.opengl;

import net.java.games.jogl.GL;

/**
 * @author stephen smith
 *
 */
public class Light extends AbstractEffect {

    private float[] lightDiffuse = { 1.0f, 1.0f, 1.0f, 1.0f }; // RGBA
    private float[] lightPosition = { 0.0f, 3.0f, 2.0f, 1.0f }; // XYZ, 1=pos of light source(?)
    
    private int no;

    /**
     * 
     */
    public Light(int n, boolean on) {
        super(on);
        this.no = n;
    }
    
    public Light(int n, boolean on, float[] diff_col, float[] pos) {
        this(n, on);
        this.lightDiffuse = diff_col;
        lightPosition = pos;
    }

    /* (non-Javadoc)
     * @see ssmith.opengl.IEffect#init()
     */
    public void init(Canvas3D canvas, GL gl) {
        //gl.glLightfv(no, GL.GL_AMBIENT, this.lightAmbient);
        gl.glLightfv(no, GL.GL_DIFFUSE, this.lightDiffuse);
        gl.glLightfv(no, GL.GL_POSITION, this.lightPosition);
        gl.glEnable(no);
        //gl.glEnable(GL.GL_LIGHTING);
    }

    /* (non-Javadoc)
     * @see ssmith.opengl.IEffect#ifOn()
     */
    public void ifOn(GL gl) {
        /*this.lightPosition[0] = this.lightPosition[0] + 0.1f;
        if (this.lightPosition[0] > 20f) {
            this.lightPosition[0] = 0f;
        }*/
/*        this.lightPosition[0] = Main.hero.location.x - (float) (Math.cos(Math.toRadians(270 - Main.hero.y_angle)));
        this.lightPosition[1] = 4f;
        this.lightPosition[2] = Main.hero.location.z - (float) (Math.sin(Math.toRadians(270 - Main.hero.y_angle)));*/
        gl.glLightfv(no, GL.GL_POSITION, this.lightPosition);
        gl.glEnable(no);
    }

    /* (non-Javadoc)
     * @see ssmith.opengl.IEffect#ifOff()
     */
    public void ifOff(GL gl) {
        gl.glDisable(no);
        
    }

}
