/*
 * Created on 03-Oct-2005
 *
 */
package ssmith.opengl;

import net.java.games.jogl.GL;

/**
 * @author stephen smith
 *
 */
public class Fog extends AbstractEffect {

    private float[] fogColor = { 0.0f, 0.0f, 0.0f, 1.0f};
    private int[] fogMode = { GL.GL_EXP, GL.GL_EXP2, GL.GL_LINEAR }; // Linear is fast
    private int fogFilter=2;
    private float start, end;

    /**
     * 
     */
    public Fog(boolean on, float start, float end) {
        super(on);
        this.start = start;
        this.end = end;
    }

    /* (non-Javadoc)
     * @see ssmith.opengl.IEffect#init()
     */
    public void init(Canvas3D canvas, GL gl) {
        //set up fog
        gl.glFogi(GL.GL_FOG_MODE, fogMode[fogFilter]);
        gl.glFogfv(GL.GL_FOG_COLOR, fogColor);
        gl.glFogf(GL.GL_FOG_DENSITY, 0.05f);
        gl.glHint(GL.GL_FOG_HINT, GL.GL_NICEST);
        gl.glFogf(GL.GL_FOG_START, start);
        gl.glFogf(GL.GL_FOG_END, end);
        gl.glEnable(GL.GL_FOG);

        
    }

    /* (non-Javadoc)
     * @see ssmith.opengl.IEffect#ifOn()
     */
    public void ifOn(GL gl) {
        gl.glEnable(GL.GL_FOG);
    }

    /* (non-Javadoc)
     * @see ssmith.opengl.IEffect#ifOff()
     */
    public void ifOff(GL gl) {
        gl.glDisable(GL.GL_FOG);
    }

}
