/*
 * Created on 03-Oct-2005
 *
 */
package ssmith.opengl;

import net.java.games.jogl.GL;

/**
 * @author stephen smith
 *
 */
public abstract class AbstractEffect {
    
    private boolean on;
    
    public AbstractEffect(boolean on) {
        this.on = on;
    }
    
    public boolean isOn() {
        return this.on;
    }
    
    public void setOnOff(boolean o) {
        this.on = o;
    }
    public abstract void init(Canvas3D canvas, GL gl);
    
    public void process(GL gl) {
        if (on) {
            ifOn(gl);
        } else {
            ifOff(gl);
        }
    }
    
    public abstract void ifOn(GL gl);
    
    public abstract void ifOff(GL gl);
    
    
    

}
