package ssmith.net;

import java.net.*;
import java.io.*;
import java.util.*;

import ssmith.lang.Functions;

public abstract class NetworkMultiServer2 extends Thread {

  private int port, max_connections;
  private ServerSocket sckListener;
  public boolean debug = false;
  private volatile boolean stopNow = false;
  public volatile ArrayList connections = new ArrayList();

  public NetworkMultiServer2(int port, int max_conns) {
	  super();
	  this.setDaemon(true);
    this.port = port;
    this.max_connections = max_conns;
  }

  public void run() {
      try {
          sckListener = new ServerSocket(port);
          while (!stopNow) {
              if (debug)
                  System.out.println("Server listening on port " + port + "...");
              Socket s = sckListener.accept();
              createConnectionPre(s);
              /*sckListener.close();
              sckListener = null;*/

              while (this.connections.size() >= this.max_connections && this.max_connections >= 0) {
                  Functions.delay(1000);
              }

          }
      }
      catch (IOException e) {
          System.err.println("IO Error: " + e.getMessage());
          e.printStackTrace();
          System.exit(-1);
      }
  }

  /**
   * Override this method when a connection is made
   */
  public void createConnectionPre(Socket sck) throws IOException {
	  NetworkMultiServerConn2 conn = createConnection(sck);
	  if (conn != null) {
		  this.connections.add(conn);
	  }
	  //System.out.println("Connection made from " + sck.getInetAddress().toString() + ".  There are now " + connections.size() + " players connected.");
  }

  public abstract NetworkMultiServerConn2 createConnection(Socket sck) throws IOException ;


  /*public NetworkMultiServerConn2 getConnection(int c) {
    return (NetworkMultiServerConn2)connections.get(c);
  }*/

  public void removeConnection(NetworkMultiServerConn2 conn) {
	  this.connections.remove(conn);
	  //System.out.println("Connection removed.  There are now " + connections.size() + " players connected.");
  }



  public void stopListening() {
    stopNow = true;
  }
  
  public void closeAll() {
      while (this.connections.size() > 0) {
          NetworkMultiServerConn2 conn = (NetworkMultiServerConn2)connections.get(0);
          conn.close();
      }
  }

  public int getPort() {
      return this.port;
  }

}
