/*
 * Created on Oct 4, 2005
 *
 */
package ssmith.game;

import java.util.ArrayList;

/**
 * @author Stephen Smith
 *
 */
public class CollisionMatrix2D {

	private static boolean DEBUG;

	private ArrayList map[][];
	private ArrayList tmp_arr = new ArrayList();
    private int size;

	/**
	 *
	 */
	public CollisionMatrix2D(int size, boolean db) {
		super();
        this.size = size;
		map = new ArrayList[size][size];
		DEBUG = db;
	}

	public boolean isSquareClear(int x, int z) {
		return getObjectsAt(x, z).size() == 0;
	}

	private ArrayList getObjectsAt(int x, int z) {
            if (map[x][z] == null) {
                map[x][z] = new ArrayList();
            }
            return map[x][z];
	}

	public ArrayList getPotentialColliders(ICollidableObject obj) {
		tmp_arr.removeAll(tmp_arr);
		float rad = obj.getRadius();

		// TL
		Object other;
		int x = (int)(obj.getX() - rad);
		int z = (int)(obj.getZ() - rad);
                int size = 0;
                try {
                    size = map[x][z].size();
                    for (int o = 0; o < size; o++) {
                        other = map[x][z].get(o);
                        if (other != obj) {
                            if (tmp_arr.contains(other) == false) {
                                tmp_arr.add(other);
                            }
                        }
                    }
                } catch (java.lang.ArrayIndexOutOfBoundsException ex) {
                    // Do nothing
                }

		//TR
		int x2 = (int)(obj.getX() + rad);
		int z2 = (int)(obj.getZ() - rad);
		if (x != x2 || z != z2) {
                    try {
			size = map[x2][z2].size();
			for(int o=0 ; o<size ; o++) {
				other = map[x2][z2].get(o);
				if (other != obj) {
					if (tmp_arr.contains(other) == false) {
						tmp_arr.add(other);
					}
				}
			}
                    } catch (java.lang.ArrayIndexOutOfBoundsException ex) {
                        // Do nothing
                    }
		}

		// BL
		int x3 = (int)(obj.getX() - rad);
		int z3 = (int)(obj.getZ() + rad);
		if (x3 != x2 || z3 != z2) {
			if (x3 != x || z3 != z) {
                            try {
				size = map[x3][z3].size();
				for(int o=0 ; o<size ; o++) {
					other = map[x3][z3].get(o);
					if (other != obj) {
						if (tmp_arr.contains(other) == false) {
							tmp_arr.add(other);
						}
					}
				}
                            } catch (java.lang.ArrayIndexOutOfBoundsException ex) {
                                // Do nothing
                            }
			}
		}

		//BR
		int x4 = (int)(obj.getX() + rad);
		int z4 = (int)(obj.getZ() + rad);
		if (x4 != x || z4 != z) {
			if (x4 != x3 || z4 != z3) {
				if (x4 != x2 || z4 != z2) {
                                    try {
					size = map[x4][z4].size();
					for(int o=0 ; o<size ; o++) {
						other = map[x4][z4].get(o);
						if (other != obj) {
							if (tmp_arr.contains(other) == false) {
								tmp_arr.add(other);
							}
						}
					}
                                    } catch (java.lang.ArrayIndexOutOfBoundsException ex) {
                                        // Do nothing
                                    }
				}
			}
		}
		if (DEBUG) {
			System.out.println("Potential colliders: " + tmp_arr.size());
		}
		return tmp_arr;
	}

	public void removeObject(ICollidableObject obj) {
		float rad = obj.getRadius();
		removeTL(obj, rad);
		removeTR(obj, rad);
		removeBL(obj, rad);
		removeBR(obj, rad);
	}

	private void removeTL(ICollidableObject obj, float rad) {
		int x = (int)(obj.getX() - rad);
		int z = (int)(obj.getZ() - rad);
		try {
                    map[x][z].remove(obj);
                    /*if (DEBUG) {
                            System.out.println("Removing " + obj.toString() + " TL from " + x + "," + z);
                        }*/
		} catch (java.lang.ArrayIndexOutOfBoundsException e) {
			// Nothing
		}
	}

	private void removeTR(ICollidableObject obj, float rad) {
		int x = (int)(obj.getX() + rad);
		int z = (int)(obj.getZ() - rad);
		try {
			map[x][z].remove(obj);
			if (DEBUG) {
				//System.out.println("Removing " + obj.toString() + " TR from " + x + "," + z);
			}
		} catch (java.lang.ArrayIndexOutOfBoundsException e) {
			// Nothing
		}
	}

	private void removeBL(ICollidableObject obj, float rad) {
		int x = (int)(obj.getX() - rad);
		int z = (int)(obj.getZ() + rad);
		try {
			map[x][z].remove(obj);
			if (DEBUG) {
				//System.out.println("Removing " + obj.toString() + " BL from " + x + "," + z);
			}
		} catch (java.lang.ArrayIndexOutOfBoundsException e) {
			// Nothing
		}
	}

	private void removeBR(ICollidableObject obj, float rad) {
		int x = (int)(obj.getX() + rad);
		int z = (int)(obj.getZ() + rad);
		try {
			map[x][z].remove(obj);
			if (DEBUG) {
				//System.out.println("Removing " + obj.toString() + " BR from " + x + "," + z);
			}
		} catch (java.lang.ArrayIndexOutOfBoundsException e) {
			// Nothing
		}
	}

	public void addObject(ICollidableObject obj) {
		//System.out.println("Adding: " + obj.toString());
		float rad = obj.getRadius();
		addTL(obj, rad);
		addTR(obj, rad);
		addBL(obj, rad);
		addBR(obj, rad);
		/*if (DEBUG) {
			this.getPotentialColliders(obj);
		}*/
	}

	private void addTL(ICollidableObject obj, float rad) {
		int x = (int)(obj.getX() - rad);
		int z = (int)(obj.getZ() - rad);
		try {
			if (map[x][z] == null) {
				map[x][z] = new ArrayList();
			}
			if (map[x][z].contains(obj) == false) {
				map[x][z].add(obj);
				if (DEBUG) {
					System.out.println("Adding " + obj.toString() + " TL to " + x + "," + z);
				}
			}
		} catch (ArrayIndexOutOfBoundsException e) {
			// Do nothing
		}
	}

	private void addTR(ICollidableObject obj, float rad) {
		int x = (int)(obj.getX() + rad);
		int z = (int)(obj.getZ() - rad);
		try {
			if (map[x][z] == null) {
				map[x][z] = new ArrayList();
			}
			if (map[x][z].contains(obj) == false) {
				map[x][z].add(obj);
				if (DEBUG) {
					System.out.println("Adding " + obj.toString() + " TR to " + x + "," + z);
				}
			}
		} catch (ArrayIndexOutOfBoundsException e) {
			// Do nothing
		}
	}

	private void addBL(ICollidableObject obj, float rad) {
		int x = (int)(obj.getX() - rad);
		int z = (int)(obj.getZ() + rad);
		try {
			if (map[x][z] == null) {
				map[x][z] = new ArrayList();
			}
			if (map[x][z].contains(obj) == false) {
				map[x][z].add(obj);
				if (DEBUG) {
					System.out.println("Adding " + obj.toString() + " BL to " + x + "," + z);
				}
			}
		} catch (ArrayIndexOutOfBoundsException e) {
			// Do nothing
		}
	}

	private void addBR(ICollidableObject obj, float rad) {
		int x = (int)(obj.getX() + rad);
		int z = (int)(obj.getZ() + rad);
		try {
			if (map[x][z] == null) {
				map[x][z] = new ArrayList();
			}
			if (map[x][z].contains(obj) == false) {
				map[x][z].add(obj);
				if (DEBUG) {
					System.out.println("Adding " + obj.toString() + " BR to " + x + "," + z);
				}
			}
		} catch (ArrayIndexOutOfBoundsException e) {
			// Do nothing
		}
	}

    public void removeAllObjects() {
        /*for(int z=0 ; z<size ; z++) {
            for(int x=0 ; x<size ; x++) {
                map[x][z] = new
            }
        }*/
        map = new ArrayList[size][size];
        /*if (Client.DEBUG) {
            System.out.println("Emptying collision matrix.");
        }*/

    }

}
