/*
 * Created on 06-Mar-2006
 *
 */
package ssmith.awt;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.Toolkit;

import javax.swing.JPanel;

public class JPanelBackground extends JPanel {

	private static final long serialVersionUID = 1L;

    private Image imgBack, imgBackScaled;
    private MediaTracker md;
    private boolean scaled_image_created = false;

    public JPanelBackground(LayoutManager arg0, boolean arg1, String fname) {
        super(arg0, arg1);
        this.loadImage(fname);
    }

    public JPanelBackground(LayoutManager arg0, String fname) {
        super(arg0);
        this.loadImage(fname);
    }

    public JPanelBackground(boolean arg0, String fname) {
        super(arg0);
        this.loadImage(fname);
    }

    public JPanelBackground(String fname) {
        super();
        this.loadImage(fname);
    }

    private void loadImage(String fname) {
        md = new MediaTracker(this);
        //this.setOpaque(false);
        this.imgBack = Toolkit.getDefaultToolkit().createImage(fname);
        this.createdScaledInstance();
    }

/*    public void resize(int x, int y) {
        super.setSize(x, y);
        this.createdScaledInstance();
    }

    public void resize(Dimension d) {
        super.setSize(d);
        this.createdScaledInstance();
    }
  */
    private void createdScaledInstance() {
    	//if (this.getWidth() > 0 && this.getHeight() > 0) {
    		if (scaled_image_created == false) {
    			Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    			this.imgBackScaled = this.imgBack.getScaledInstance(dim.width, dim.height, Image.SCALE_SMOOTH);
    	        this.md.addImage(imgBackScaled, 0, dim.width, dim.height);

    	    	try {
    				md.waitForAll();
    			} catch (InterruptedException e) {
    				e.printStackTrace();
    			}

    	        this.repaint();
    			scaled_image_created = true;
    		}
    	//}
    }

    protected void paintComponent(Graphics g) {
        g.drawImage(this.imgBackScaled, 0, 0, this);
    }

}
