/*
 * Created on Oct 16, 2005
 *
 */
package ssmith.audio;

import java.io.*;
import java.net.URL;
import java.util.Hashtable;
import java.applet.*;

/**
 * @author Stephen Smith
 *
 */
public class SoundCache {

	private Hashtable sounds = new Hashtable();
	public boolean mute = false;
	//private String filename;

    public SoundCache(boolean m) {
        this.mute = m;
    }

        /**
         * Call this only, to play a sound.
         * @param fname String
         */
        public void playSound(String filename) {
            AudioClip clip;
            try {
                        if (sounds.containsKey(filename) == false) {
                            URL url = new URL("file:" + new File(".").getCanonicalPath() + "/" + filename);
                            clip = Applet.newAudioClip(url);
                            sounds.put(filename, clip);
                        }
                        if (this.mute == false) {
                            clip = (AudioClip) sounds.get(filename);
                            clip.play();
                        }
                    } catch (FileNotFoundException e) {
                        e.printStackTrace();
                    } catch (IOException e1) {
                        e1.printStackTrace();
                    } catch (Exception e2) {
                        e2.printStackTrace();
            }

        }

/*	public void playSound_Orig(String Filename) {
		AudioClip clip;
		try {
			if (sounds.containsKey(Filename) == false) {
				URL url = new URL("file:" + new File(".").getCanonicalPath() + "/" + Filename);
				clip = Applet.newAudioClip(url);
				sounds.put(Filename, clip);
			}
			if (!mute) {
				clip = (AudioClip)sounds.get(Filename);
				clip.play();
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e1) {
			e1.printStackTrace();
		} catch (Exception e2) {
			e2.printStackTrace();
		}
	}*/

}
