package ngrave.server.objects;

import ngrave.server.IDamagable;
import ngrave.server.S2CCommunication;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.ServerFunctions;


public class SRocket extends SObject implements IDamagable {

  public static final float DIAMETER = 0.2f, SPEED=1f;

  public SPlayerObject3D shooter;

  private int move_iterations = (int)(SPEED / DIAMETER);
  private float move_dist = SPEED / move_iterations;

  public SRocket(SPlayerObject3D shot_by, int angle_adj) {
    super(shot_by.getX(), shot_by.getZ(), shot_by.getAngle() + angle_adj, DIAMETER, shot_by.side, false, 0f);
    this.shooter = shot_by;
    this.setSpeed(move_dist);

    this.setLocation(shooter.getX(), shooter.getZ(), false);
    this.turnRegardless(shooter.getAngle(), true, false, false);

    S2CCommunication.SendNewObjectToAll(this);
  }

  public boolean canTraverse(SMapSquare sq) {
    return sq.blocks_targetting_view == false;// < SMapSquare.START_OF_VIEW_BLOCKERS;
  }

  public void process() {
    for (int i=0 ; i<move_iterations ; i++) {
      this.moveForwardsRegardless();
      if (this.canTraverseMap() == false) {
        this.moveBackwardsRegardless(move_dist);// So we're not inside a wall when we explode.
        this.damage(1, 0);
        return;
      } else {
        checkCollisions(null);
        if (isDestroyed()) {
          return;
        }
      }
    }
    S2CCommunication.SendObjectUpdateToAll(this, false);
  }

/*  protected boolean checkCollisions() throws IOException {
    SObject obj;
    for (int o=0 ; o<Server.objects.length ; o++) {
      obj = Server.objects[o];
      if (obj != null) {
        if (this != obj) {
          if (obj.can_collide) {
          	if (obj instanceof SBullet || obj instanceof  SRocket) {
          		// Cant collide with other bullets or rockets.
       			continue;
          	}
            // See if any objects have collided.
            if (this.collidedWith(obj)) {
              return this.hasCollidedWith(obj);
            }
          }
        }
      }
    }
    return false;
  }
*/
  public boolean hasCollidedWith(SObject other) {
    // Check we haven't hit our shooter.
  	if (this.shooter != other) {
  		this.damage(1, 0);
  	    return true;
      }
  	return false;
  }

/*  protected boolean hasCollidedWith_Old(SObject other) throws IOException {
    if (other instanceof SPlayerObject3D) {
      // Check we haven't hit ourslves
      SPlayerObject3D target = (SPlayerObject3D) other;
      if (this.shooter != target) {
      	this.damage(1, 0);
      }
    } else {
      damage(1, 0);
    }
    return true;
  }
*/
  public void damage(int amt, int angle_of_attack) {
    if (this.isDestroyed() == false) {
      this.setDestroyed(); // We must set destoyed here otherwise it gets into an infinte loop of explosions
      ServerFunctions.explode(this);//, EXPLOSION_RANGE, DAMAGE);
      // Now destroy any walls
      Server.map.removeWalls(this, 3);
      this.remove(false);
    }
  }

}
