package ngrave.server.objects;

import java.io.IOException;

import ngrave.server.IDamagable;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.ServerFunctions;

public class SGrenade extends SObject implements IDamagable {

  public static final float RADIUS = 0.07f;

  private float prime_time; // SHould be int as they may set if for a long time.
  public boolean primed = false;

  public SGrenade(float x, float z, byte side) throws IOException {
    super(x, z, 0, 0f, side, false, 0.5f);
  }

  public void setPrimeTime(int time) {
    this.prime_time = time;
    this.primed = true;
  }

  public boolean canTraverse(SMapSquare sq) {
    return sq.blocks_targetting_view == false;
  }

  public void process() {
  	// Do nothing
  }

  /**
   * This is only used when APs are being used, to reduce the grenades timer.
   * Otherwise, process() is used.
   */
  public void reducePrimeTime(float amt) throws IOException {
    this.prime_time -= amt;
    if (prime_time <= 0) {
      this.damage(999, 0);
    }
  }

  /**
   * This is effectively explode().
   */
  public void damage(int amt, int angle_of_attack) {
	  if (this.isDestroyed() == false) {
		  this.setDestroyed(); // We must set destoyed here otherwise it gets into an infinte loop of explosions
		  //S2CCommunication.SendMessage(this.current_controller.getID(), "The grenade has exploded", (byte)2);
		  ServerFunctions.explode(this);//, EXPLOSION_RANGE, DAMAGE);
		  // Now destroy any walls
		  Server.map.removeWalls(this, 2);
		  this.remove(false);
	  }
  }


}
