package ngrave.server.objects;

import ngrave.server.IDamagable;
import ngrave.server.S2CCommunication;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.ServerFunctions;

public class SCrate extends SObject implements IDamagable {

//  private static final int DAMAGE=100, EXPLOSION_RANGE=4;
  public static final float SIZE=0.4f;

  //private boolean exploded = false; // Must use this so the canSee works (ie. don't use destroyed()).

  public SCrate(float x, float z) {
    super(x, z, 0, SIZE, (byte)-1, false, 0);
    S2CCommunication.SendNewObjectToAll(this);
  }

  public void process() {
  }

  public void damage(int amt, int angle_of_attack) {
    explode();
  }

  public void explode() {
    if (this.isDestroyed() == false) {
        this.setDestroyed(); // We must set destoyed here otherwise it gets into an infinte loop of explosions
      ServerFunctions.explode(this);//, EXPLOSION_RANGE, DAMAGE);
      Server.map.removeWalls(this, 1.4);
      this.remove(false);
    }
  }

  public boolean canTraverse(SMapSquare sq) {
    return false;
  }

}
