package ngrave.server.objects;

import ngrave.server.S2CCommunication;
import ngrave.server.SMapSquare;
import ssmith.util.Interval;

public class SBulletTrail extends SObject {

  public static final float DIAMETER = 0.2f; // Logical size for collision detection.
  private Interval display_interval = new Interval(200);

  public SBulletTrail(SPlayerObject3D shot_by, SBullet bullet) {
    super(bullet.getX(), bullet.getZ(), bullet.getAngle(), DIAMETER, shot_by.side, true, 0f);

    S2CCommunication.SendNewObjectToAll(this);
  }

  public void process() {
	  if (this.display_interval.hitInterval()) {
		  this.remove(false);
	  }
  }


  public boolean canTraverse(SMapSquare sq) {
    return false;
  }

}
