package ngrave.server.objects;

import ngrave.client.Client;
import ngrave.server.IDamagable;
import ngrave.server.S2CCommunication;
import ngrave.server.SMapSquare;
import ngrave.server.ServerFunctions;

public class SBullet extends SObject {

  public static final float DIAMETER = 0.2f; // Logical size for collision detection.
  public static final float SPEED=0.4f; // was 0.6f

  private SPlayerObject3D shooter;
  private int damage;
  private int move_iterations = (int)(SPEED / DIAMETER);
  private float move_dist = SPEED / move_iterations;
  private static int no_of_bullets=0;

  public SBullet(SPlayerObject3D shot_by, int angle_adj,  int damage) {
    super(shot_by.getX(), shot_by.getZ(), shot_by.getAngle() + angle_adj, DIAMETER, shot_by.side, false, 0f);

    this.setSpeed(move_dist);
    //System.out.println("Iterations: " + this.move_iterations);

    this.shooter = shot_by;
    this.damage = damage;

    S2CCommunication.SendNewObjectToAll(this);
    
    no_of_bullets++;
  }

  public void remove(boolean killed) {
	  super.remove(killed);
	  no_of_bullets--;
  }
  
  public boolean isBullets() {
	  return no_of_bullets > 0;
  }
  
  public void process() {
	  for (int i=0 ; i<move_iterations ; i++) {
		  this.moveForwardsRegardless();
		  if (this.canTraverseMap() == false) {
			  this.moveBackwardsRegardless(move_dist);
			  S2CCommunication.SendExplosion(this, 20, 2);
			  this.remove(false);
			  return;
		  } else {
			  checkCollisions(null); // has its own version
			  if (isDestroyed()) {
				  S2CCommunication.SendExplosion(this, 60, 2);
				  return;
			  }
		  }
		  if (Client.SHOW_BULLETTRAILS) {
			  new SBulletTrail(this.shooter, this);
		  }
	  }
	  S2CCommunication.SendObjectUpdateToAll(this, false);
  }


  public boolean canTraverse(SMapSquare sq) {
    return sq.blocks_targetting_view == false;// < SMapSquare.START_OF_VIEW_BLOCKERS;
  }

  /**
   * Note that we now only check for collisions with objects we own!
   */
  public boolean hasCollidedWith(SObject other) {
  	if (other instanceof SPlayerObject3D) {
  		SPlayerObject3D target = (SPlayerObject3D) other;
  		if (other != shooter) {
  			target.setGuard(false, true); // Turn off skip so we don't get blasted before we have chance to move!

  			// Send message
  			byte pri = 1;
  			if (target.side == shooter.side) {
  				pri = 2;
  			}

  			String s1 = ServerFunctions.getSideName(shooter.side);
  			String s2 = ServerFunctions.getSideName(target.side);
  			S2CCommunication.SendMessageToAll(s1 + " " + shooter.name + " has shot " + s2 + " " + target.name + ".", pri);

  			if (this.shooter.side == target.side) { // Is the shooter the same side as the target?
  				S2CCommunication.SendMessageToAllOnSide(shooter.name + " has shot their own side!", (byte)2, shooter.side);
  				//System.out.println(shooter.name + " has shot their own side! (" + target.name + ")");
  				this.shooter.setAutofire(false, true);
  				if (shooter.isComputerControlled() == false) {
  					// Only damage them if not computer controlled
  					target.damage(this.damage, target.getAbsoluteAngleTo(this));
  				}
  			} else {
  				target.damage(this.damage, target.getAbsoluteAngleTo(this));
  			}

  			if (target.ai != null) {
  				target.ai.hitByBullet(this.shooter);
  			}

  			this.remove(false);

  		} else {
  			return false;
  		}
  	} else if (other instanceof IDamagable) {
  		IDamagable explodable = (IDamagable) other;
  		explodable.damage(this.damage, other.getAbsoluteAngleTo(this));
  		this.remove(false);
  	}
  	return true;
  }
}
