package ngrave.server.objects;

import ngrave.server.IDamagable;
import ngrave.server.S2CCommunication;
import ngrave.server.SMapSquare;
import ngrave.server.ServerFunctions;

public class SBarrel extends SObject implements IDamagable {

  public static final float RADIUS = 0.25f, HEIGHT=0.6f;

  public SBarrel(float x, float z) {
    super(x, z, 0, RADIUS*2, (byte)-1, false, 0);
    S2CCommunication.SendNewObjectToAll(this);
  }

  public void process() {
  }

  public void damage(int amt, int angle_of_attack) {
    if (!isDestroyed()) {
    	this.setDestroyed(); // We must set destoyed here otherwise it gets into an infinte loop of explosions
      ServerFunctions.explode(this);//, EXPLOSION_RANGE, DAMAGE);
      this.remove(false);
    }
  }

  public boolean canTraverse(SMapSquare sq) {
    return false;
  }

}
