package ngrave.server.items;

import ssmith.lang.Functions;
import ngrave.misc.ItemsFile;
import ngrave.server.S2CCommunication;
import ngrave.server.Server;
import ngrave.server.objects.SBullet;
import ngrave.server.objects.SPlayerObject3D;
import ngrave.server.objects.SRocket;

public class SWeaponCarried extends SItemCarried {

	public long shot_time;
	public int ammo, clip_size, damage, shot_aps;
	public float accuracy;
	public boolean can_autofire;

	public SWeaponCarried(byte type) {
		super(type);
		getStatsFromCSVFile(type);
	}

	private void getStatsFromCSVFile(byte type) {
		//System.out.println("Getting "+name);
		ItemsFile file = new ItemsFile();
		file.getStatsFromCSVFile(type);
		this.cost = file.cost;
		this.damage = file.damage;
		this.shot_aps = file.shot_aps;
		this.accuracy = file.accuracy;
		this.clip_size = file.clip_size;
		this.ammo = this.clip_size;
		this.can_autofire = file.can_autofire;
	}

	public StringBuffer getInfo() {
		StringBuffer str = new StringBuffer();
		str.append("Ammo: " + this.ammo + "\n");
		str.append("Damage: " + this.damage + "\n");
		str.append("Accuracy: " + this.accuracy + " degrees\n");
		return str;
	}

	public boolean use(SPlayerObject3D shooter) {
		if (ammo > 0) {
			int aps_reqd = shooter.getShotAPCost(this);
			if (shooter.getAPs() >= 1) { // As some weapons will cost too much to shot on acc setting.
				int ang = shooter.getAngleForShootingAccuracy(this);
				shot_time = System.currentTimeMillis();
				ammo--;
				S2CCommunication.SendAmmoLevel(shooter, this);
				if (this.type == SItemCarried.ROCKET_LAUNCHER) {
					new SRocket(shooter, ang);
					shooter.removeItem(this);
				} else {
					new SBullet(shooter, ang, damage);
				}
				shooter.reduceAPs(aps_reqd, true);
				return true;
			}
		} else {
			if (Functions.rnd(1, 5) == 1) {
				S2CCommunication.SendMessageToAllOnSide(this.name +": I'm out of ammo!", (byte)0, shooter.side);
			}
		}
		return false;
	}

	public void reload(SPlayerObject3D shooter) {
		if ((this.type == SWeaponCarried.ROCKET_LAUNCHER) == false) {
			if (ammo < clip_size) {
				if (shooter.getAPs() >= SPlayerObject3D.RELOAD_COST) {
					this.ammo = clip_size;
					shooter.reduceAPs(SPlayerObject3D.RELOAD_COST, true);
					return;
				}
				else {
					S2CCommunication.SendMessage(shooter.getCurrentController(), "You do not have enough action points.", (byte)0);
				}
			}
		} else {
			S2CCommunication.SendMessage(shooter.getCurrentController(), "You cannot reload a Rocket Launcher.", (byte)0);
		}
	}

}
