/*
 * Created on 27-May-2005
 *
 */
package ngrave.server.items;

import java.io.IOException;

import ngrave.server.S2CCommunication;
import ngrave.server.Server;
import ngrave.server.objects.SPlayerObject3D;



/**
 * @author stephen smith
 *
 */
public class SMediKitCarried extends SItemCarried {
	
	/**
	 * @param type
	 * @throws IOException
	 */
	public SMediKitCarried() throws IOException {
		super(SItemCarried.MEDIKIT);
	}

	/* (non-Javadoc)
	 * @see ngrave.SItemCarried#use(ngrave.SPlayerObject3D)
	 */
	public boolean use(SPlayerObject3D user) {
		boolean patient_found = false;
		SPlayerObject3D obj;
		for (int o = 0; o < Server.objects.length; o++) {
			if (Server.objects[o] != null) {
				if (Server.objects[o] instanceof SPlayerObject3D) {
					obj = (SPlayerObject3D) Server.objects[o];
					if (obj.side == user.side) {
						if (obj != user) {
							if (user.distanceTo(obj) < 1) {
								int ang = user.getAbsoluteAngleTo(obj);
								//System.out.println("1: " + this.y_angle + "  them: "+ang);
								if (user.isWithinAngle(ang, 20)) {
									patient_found = true;
									obj.heal();
									user.removeItem(this.ref);
									S2CCommunication.SendMessage(obj.getCurrentController(), "" + obj.name + " healed.", (byte)0);
								}
							}
						}
					}
				}
			}
		}

		if (patient_found == false) {
			S2CCommunication.SendMessage(user.getCurrentController(), "Cannot find a patient.", (byte)0);
		}
		return patient_found;

	}

}
