package ngrave.server.items;

import ngrave.misc.ItemsFile;
import ngrave.server.objects.SPlayerObject3D;


/**
 * Class for storing details about items that can be used.
 * If a grenade is thrown, that creates a completely new item!
 */
public abstract class SItemCarried  {

  // These must match up with the equipment CSV file!
  public static final byte LASER_RIFLE = 1, ROCKET_LAUNCHER = 2;
  public static final byte GRENADE = 3;
  public static final byte EXTERMINATOR = 5, HEAVY_LASER = 6;
  public static final byte BLASTER = 7, DEATH_RAY = 8;
  public static final byte SNIPER_RIFLE=9, PISTOL=10;
  public static final byte PLASMA_CANNON=11, MEDIKIT=12;

  public static final int THROW_ACCURACY = 6, THROW_MAX_DIST=20;

  public int ref, cost;
  private static int next_ref = 0;
  public byte type;
  public String name;

  /*public static SItemCarried ItemFactory(byte type) throws IOException {
    switch (type) {
      case LASER_RIFLE:
        return new SWeaponCarried(LASER_RIFLE);
      default:
        System.err.println("Unknown item for creation: "+type);
        return null;
    }
  }*/

  public SItemCarried(byte type) {
    this.type = type;
    this.ref = next_ref++;

    // Get the cost from CSV file
    ItemsFile file = new ItemsFile();
    file.getStatsFromCSVFile(type);
    this.cost = file.cost;
    this.name = file.name;
  }

  public abstract boolean use(SPlayerObject3D user);

  public String toString() {
    return name;
  }

}
