package ngrave.server.items;

import ssmith.lang.Functions;
import java.io.*;

import ngrave.server.S2CCommunication;
import ngrave.server.objects.SGrenade;
import ngrave.server.objects.SPlayerObject3D;


public class SGrenadeCarried extends SItemCarried {

  public static final int PRIME_AND_THROW_COST=10;

  public SGrenadeCarried() {
    super(SItemCarried.GRENADE);
  }

  public boolean use(SPlayerObject3D user) {
    // Do nothing - not used here!
    return false;
  }

  public void primeAndThrow(SPlayerObject3D trooper, int time, int dist) throws IOException {
		if (trooper.getAPs() >= SGrenadeCarried.PRIME_AND_THROW_COST) {
    SGrenade gren = new SGrenade(trooper.getX(), trooper.getZ(), trooper.side);
    gren.setPrimeTime(time);

    S2CCommunication.SendNewObjectToAll(gren);

      // Now throw it!
    gren.turnRegardless(trooper.getAngle() + Functions.rnd(-THROW_ACCURACY, THROW_ACCURACY), true, false, true);

    if (dist > 3) {
    	dist = (int)Functions.rndDouble(dist*.75, dist*1.25);
    }
    S2CCommunication.SendMessage(trooper.getCurrentController(), "Item thrown "+dist, (byte)1);

    int iterations = (int)(dist/gren.getSpeed());
    for (int d=0 ; d<iterations ; d++) {
      gren.moveForwardsRegardless();
      S2CCommunication.SendObjectUpdateToAll(gren, false);
      if (gren.canTraverseMap() == false) {
        gren.moveBackwardsRegardless(gren.getSpeed()*2);
        S2CCommunication.SendObjectUpdateToAll(gren, false);
        break;
      }
    }
		}
		
		trooper.reduceAPs(SGrenadeCarried.PRIME_AND_THROW_COST, true);

    trooper.removeItem(this.ref);
  }

}

