package ngrave.server;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import ngrave.client.Client;
import ngrave.missions.Mission;
import java.awt.*;

public class frmServerOptionForm extends JFrame {

	private static final long serialVersionUID = 1L;

	JPanel jPanel1 = new JPanel();
	JButton cmdOK = new JButton();
	public JComboBox cbMissionFile = new JComboBox();
	JLabel lblTitle = new JLabel();
	GridLayout gridLayout1 = new GridLayout();
	public JCheckBox optRandomMap = new JCheckBox();
	public boolean ok_clicked = false;
	JTextArea txtMissionDesc = new JTextArea();
	JTextField txtPort = new JTextField();
	JLabel jLabel1 = new JLabel();
	JLabel lblMission = new JLabel();
	private ServerSettings settings = new ServerSettings();
    JLabel jLabel2 = new JLabel();
    JCheckBox chkAttackers = new JCheckBox();
    JCheckBox chkDefenders = new JCheckBox();

    public frmServerOptionForm() throws Exception {
		try {
			jbInit();
			this.setTitle(Statics.TITLE + " Server Options");
			this.setLocation(200, 200);
			this.setSize(302, 420);

			this.cbMissionFile.addItem("TheAssassins");
			this.cbMissionFile.addItem("MoonbaseAssault");
			this.cbMissionFile.addItem("RescueFromTheMines");
			this.cbMissionFile.addItem("DestroyTheBase");
			this.cbMissionFile.addItem("Baghdad3000");
			//this.cbMissionFile.addItem("GuerillaWar");
			this.cbMissionFile.addItem("Deathwing");
			this.cbMissionFile.addItem("BattleInTheJungle");
			this.cbMissionFile.addItem("EscapeFromTheMoonbase");

			this.txtPort.setText(settings.port);
			if (this.txtPort.getText().length() == 0) {
				this.txtPort.setText("" + Server.PORT);
			}
			//this.optCPUSide.addItem("Both");
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	private void showMissionDesc() {
		try {
			String class_file = "ngrave.missions." + cbMissionFile.getSelectedItem().toString();
			Class mission_class = Class.forName(class_file);
			Mission mission = (Mission)mission_class.newInstance();
			this.txtMissionDesc.setText(mission.getDescription());
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}

	}

	private void jbInit() throws Exception {
		this.getContentPane().setLayout(gridLayout1);
		jPanel1.setLayout(null);
		this.setResizable(true);
		this.setTitle(Statics.TITLE);
		cmdOK.setBounds(new Rectangle(199, 349, 82, 31));
		cmdOK.setToolTipText("Get Ready!");
		cmdOK.setText("OK");
		cmdOK.addActionListener(new frmServerOptionForm_cmdOK_actionAdapter(this));
		cbMissionFile.setBounds(new Rectangle(88, 97, 196, 27));
		cbMissionFile.addActionListener(new frmServerOptionForm_cbMissionFile_actionAdapter(this));
		optRandomMap.setToolTipText("Generate a random map instead.");
		optRandomMap.setText("Random Map");
		optRandomMap.setBounds(new Rectangle(105, 248, 122, 30));
		lblTitle.setFont(new java.awt.Font("Dialog", 1, 18));
		lblTitle.setText(Statics.TITLE + " (v"+Client.VERSION +") Server");
		lblTitle.setBounds(new Rectangle(7, 7, 342, 32));
		txtMissionDesc.setEditable(false);
		txtMissionDesc.setText("");
		txtMissionDesc.setLineWrap(true);
		txtMissionDesc.setWrapStyleWord(true);
		txtMissionDesc.setBounds(new Rectangle(32, 137, 249, 100));
		txtMissionDesc.setBackground(Color.LIGHT_GRAY);
		txtPort.setText("");
		txtPort.setBounds(new Rectangle(88, 57, 112, 32));
		jLabel1.setText("Port");
		jLabel1.setBounds(new Rectangle(46, 63, 59, 19));
		lblMission.setText("Mission");
		lblMission.setBounds(new Rectangle(13, 101, 69, 19));
        jLabel2.setText("CPU Side:");
		jLabel2.setBounds(new Rectangle(19, 279, 60, 29));
        chkAttackers.setText("Attackers");
        chkAttackers.setBounds(new Rectangle(106, 282, 189, 25));
        chkDefenders.setText("Defenders");
        chkDefenders.setBounds(new Rectangle(106, 306, 189, 29));
        jPanel1.add(lblTitle, null);
        jPanel1.add(jLabel1);
        jPanel1.add(txtPort);
        jPanel1.add(cbMissionFile, null);
        jPanel1.add(lblMission);
        jPanel1.add(txtMissionDesc, null);
        jPanel1.add(optRandomMap, null);
        jPanel1.add(jLabel2);
        jPanel1.add(chkAttackers);
        jPanel1.add(chkDefenders);
        jPanel1.add(cmdOK, null);
        this.getContentPane().add(jPanel1, null);

    }

	void cmdOK_actionPerformed(ActionEvent e) {
		settings.saveSettings(this.txtPort.getText());
		this.ok_clicked = true;
		this.setVisible(false);
	}

	void cbMissionFile_actionPerformed(ActionEvent e) {
		this.showMissionDesc();

		// Enable/disable random map option
		try {
			Class mission_class = Class.forName("ngrave.missions." + cbMissionFile.getSelectedItem().toString());
			Mission mission = (Mission)mission_class.newInstance();
			this.optRandomMap.setEnabled(mission.randomMap());
			if (this.optRandomMap.isEnabled() == false) {
				this.optRandomMap.setSelected(false);
			}
		} catch (ClassNotFoundException e1) {
			e1.printStackTrace();
		} catch (InstantiationException e1) {
			e1.printStackTrace();
		} catch (IllegalAccessException e1) {
			e1.printStackTrace();
		}

	}


}


class frmServerOptionForm_cmdOK_actionAdapter implements java.awt.event.ActionListener {
	frmServerOptionForm adaptee;

	frmServerOptionForm_cmdOK_actionAdapter(frmServerOptionForm adaptee) {
		this.adaptee = adaptee;
	}
	public void actionPerformed(ActionEvent e) {
		adaptee.cmdOK_actionPerformed(e);
	}
}

class frmServerOptionForm_cbMissionFile_actionAdapter implements java.awt.event.ActionListener {
	frmServerOptionForm adaptee;

	frmServerOptionForm_cbMissionFile_actionAdapter(frmServerOptionForm adaptee) {
		this.adaptee = adaptee;
	}
	public void actionPerformed(ActionEvent e) {
		adaptee.cbMissionFile_actionPerformed(e);
	}
}
