/*
 * Created on 07-Nov-2006
 *
 */
package ngrave.server;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.*;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import java.util.Date;

public class frmServerLog extends JFrame {

	private static final long serialVersionUID = 1L;

    private StringBuffer sb_log = new StringBuffer();
    private StringBuffer sb_settings = new StringBuffer();

    public frmServerLog() {
        super();
        try {
            jbInit();
            this.txtLog.setEditable(false);
            this.txtSettings.setEditable(false);
            this.setTitle(Statics.TITLE + " Server");
            this.setSize(360, 340);
            this.setVisible(true);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setNoOfPlayers(int n) {
        this.txtNoOfPlayers.setText("" + n);
    }

    public void log(String s) {
        sb_log.append(new Date().toString() + ": " + s + "\n");
        this.txtLog.setText(sb_log.toString());
    }

    public void addSetting(String s) {
        sb_settings.append(s + "\n");
        this.txtSettings.setText(sb_settings.toString());
    }

    private void jbInit() throws Exception {
        jPanel1.setLayout(gridLayout1);
        cmdQuit.addActionListener(new frmServerLog_cmdQuit_actionAdapter(this));
        txtNoOfPlayers.setEditable(false);
        txtSettings.setText("");
        txtLog.setText("");
        gridLayout1.setColumns(3);
        jScrollPane2.getViewport().add(txtLog);
        jScrollPane1.getViewport().add(txtSettings);
        txtNoOfPlayers.setText("0");
        cmdQuit.setText("Quit");
        gridLayout2.setColumns(1);
        gridLayout2.setRows(3);
        jPanel1.add(jLabel1);
        jPanel1.add(txtNoOfPlayers);
        jPanel1.add(cmdQuit);
        jLabel1.setText("Players");
        this.getContentPane().setLayout(gridLayout2);
        this.getContentPane().add(jScrollPane1);
        this.getContentPane().add(jScrollPane2);
        this.getContentPane().add(jPanel1);
    }

    JPanel jPanel1 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JLabel jLabel1 = new JLabel();
    JTextField txtNoOfPlayers = new JTextField();
    JButton cmdQuit = new JButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTextArea txtSettings = new JTextArea();
    JTextArea txtLog = new JTextArea();
    GridLayout gridLayout2 = new GridLayout();

    public void cmdQuit_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        Server.QuitNow();
    }

}


class frmServerLog_cmdQuit_actionAdapter implements ActionListener {
    private frmServerLog adaptee;
    frmServerLog_cmdQuit_actionAdapter(frmServerLog adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.cmdQuit_actionPerformed(e);
    }
}
