package ngrave.server;

import java.io.IOException;
import ssmith.io.*;
import ssmith.util.CSVString;

public final class ServerSettings {

	private static final String FILENAME = "server_settings.dat";
	private static final String PORT = "port";

	public String port = "";

	public ServerSettings() {
		super();
		TextFile tf = new TextFile();
		try {
			tf.openFile(FILENAME, TextFile.READ);
			while (tf.isEOF() == false) {
				CSVString line = new CSVString(tf.readLine(), "=");
				if (line.getFirstSection().equalsIgnoreCase(PORT)) {
					port = line.getSection(1);
				}
			}
			tf.close();
		} catch (IOException e) {
			// Nothing
		}

	}

	public void saveSettings(String port) {
		TextFile tf = new TextFile();
		try {
			tf.openFile(FILENAME, TextFile.WRITE);
			tf.writeLine(PORT + "=" + port);
			tf.close();
		} catch (IOException e) {
			// Nothing
		}
	}

}
