package ngrave.server;

import ngrave.server.objects.SObject;
import ssmith.lang.Functions;

public final class ServerFunctions {

  public static final int DAMAGE=300, EXPLOSION_RANGE=5;

  private ServerFunctions() {
  }

  public static String getSideName(byte side) {
  	switch (side) {
  		case 0: return "Attacker";
  		case 1: return "Defender";
  		default: return "Unknown";
  	}
  }

  public static void explode(SObject exploder) {
    // Explode!
    S2CCommunication.SendExplosion(exploder, 100, EXPLOSION_RANGE);
    S2CCommunication.SendScenery(S2CCommunication.SMOKE, exploder.getX(), exploder.getZ(), exploder.getAngle());
    // See who's been hit
    try {
      for (int o = 0; o < Server.objects.length; o++) {
        if (Server.objects[o] instanceof IDamagable) {
          SObject obj = Server.objects[o];
          if (obj != exploder) {
            float dist = exploder.distanceTo(obj);
            if (dist <= EXPLOSION_RANGE) {
              if (exploder.canSee(obj, false)) {
                int dam = (int) (DAMAGE / dist);
                /*if (Client.DEMO) {
                	System.out.println(obj.toString() + " was "+dist+" away and was damaged "+dam+".");
                }*/
                ( (IDamagable) (obj)).damage(dam, obj.getAbsoluteAngleTo(exploder));
              }
            }
          }
        }
      }
    } catch (java.lang.IndexOutOfBoundsException ex) {
      // Probably caused by an object being removed from Objects by another thread
      System.err.println(ex.getMessage());
      ex.printStackTrace();
    }
  }

  /**
   * There is also an equivalent function in CObject for
   * the client to work it out itself.
   */
  public static boolean CanSee(float sx, float sz, float tx, float tz) {
    float x = sx;
    float z = sz;
    double iterations = Functions.distance(sx, sz, tx, tz) * 4; // was 7
    double x_off = (tx - x) / iterations;
    double z_off = (tz - z) / iterations;
    int last_x = -1;
    int last_z = -1;
    iterations = iterations - 2; // So we don't go too far
    for (int s = 0; s < iterations; s++) {
      x += x_off;
      z += z_off;
      if (last_x != (int) x || last_z != (int) z) {
      	if (Server.map.getMapSquare(x, z).blocks_targetting_view) {// .type >= SMapSquare.START_OF_VIEW_BLOCKERS) {
      		return false;
      	}
      }
   	last_x = (int)x;
  	last_z = (int)z;
    }
    return true;

  }

  public static byte getOppositeSide(byte s) {
      return s == (byte)0 ? (byte)1 : (byte)0;
  }

/*  public static int GetCommsVersion(float v) {
      return (int)(v * 10);
  }
*/
}
