/*
    Laser Tactics - Copyright (C)2008 Stephen Carlyle-Smith <steve16384@users.sourceforge.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package ngrave.server;

import ssmith.audio.SoundCache;
import ssmith.game.CollisionMatrix2D;
import ssmith.lang.Functions;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ListIterator;
import java.util.Date;
import ngrave.client.C2SCommunication;
import ngrave.client.Client;
import ngrave.server.objects.SGrenade;
import ngrave.server.objects.SObject;
import ngrave.server.objects.SPlayerObject3D;

public final class Server {

	private static final String EXCEPTION_FILE = "Server_Exception.txt";
	public static final int START_OBJECTS=100, PORT=16384;
	public static final byte MAX_ACTION_POINTS=20;
	public static final int GAME_CONNECT_PORT = 40000;
	public static final int MAX_CONNECTIONS = 15;
	private static final long MAX_BLOCK_GAME_TIME = 20000;
	private static final int LOOP_DELAY = 5;

	private WaitForPlayersThread net_server;
	public static SPlayers players = new SPlayers();
	public static SMapData map;
	public static SObject[] objects;
	public static SGame game;
	private SPlayerObject3D waiting_for = null;
	private long waiting_since=0;
	private boolean sent_holdup_warning = false;
	public static frmServerLog frm_log;
	private static boolean quit_now = false;
	public static SoundCache sfx = new SoundCache(Statics.MUTE);

	public static void main(String[] args) {
		new Server();
	}

	public Server() {
		super();
		try {
			int port = -1;
			//byte i_cpu_side = -1;
			boolean attackers_are_cpu, defenders_are_cpu;
			boolean b_random = false;
			String s_mission = null;

				frmServerOptionForm options = new frmServerOptionForm();
				if (!Client.QUICKSTART) {
					options.setVisible(true);
					while (options.isVisible()) {
						Functions.delay(1000);
					}
					if (options.ok_clicked == false) {
						System.exit(0);
					}
				}
				s_mission = options.cbMissionFile.getSelectedItem().toString();
				port = new Integer(options.txtPort.getText()).intValue();
				b_random = options.optRandomMap.isSelected();
				attackers_are_cpu = options.chkAttackers.isSelected();
				defenders_are_cpu = options.chkDefenders.isSelected();

			game = new SGame(s_mission,  b_random, attackers_are_cpu, defenders_are_cpu);

			frm_log = new frmServerLog();
			/*log(Client.TITLE + " Server (v" + Client.VERSION + ")", false);
            log("Server IP Address: " + InetAddress.getLocalHost(), false);
            log("Server Name: " + server_name, false);
            log("Mission: " + s_mission, false);
            if (i_cpu_side >= 0) {
                log("Creating AI for " + ServerFunctions.getSideName(i_cpu_side), false);
            }*/
			frm_log.addSetting(Statics.TITLE + " Server (v" + Client.VERSION + ")");
			frm_log.addSetting("Server IP Address: " + InetAddress.getLocalHost());
			frm_log.addSetting("Mission: " + s_mission);
			if (attackers_are_cpu) {
				frm_log.addSetting("Creating AI for " + ServerFunctions.getSideName(Client.ATTACKER));
			}
			if (defenders_are_cpu) {
				frm_log.addSetting("Creating AI for " + ServerFunctions.getSideName(Client.DEFENDER));
			}

			game.setupNewGame();
			net_server = new WaitForPlayersThread(port);
			frm_log.addSetting("Listening on port " + port);
			net_server.start(); // Start listening for players

			mainGameLoop();
		} catch (Exception ex) {
			HandleError(ex);
			System.exit(1);
		}

	}

	private void mainGameLoop() {
		while (quit_now == false) {
			long start = System.currentTimeMillis();
			if (players.getNoOfPlayers() > 0) {
				try {
					decodeData();

					float highest_ap = 0;
					SObject obj;
					SPlayerObject3D highest_ap_unit = null;
					for (int o = 0; o < objects.length; o++) {
						obj = objects[o];
						if (obj != null) {
							/*if (obj instanceof SPlayerObject3D) {
								SPlayerObject3D player_obj2 = (SPlayerObject3D) obj;
								if (player_obj2.name.equalsIgnoreCase("Gunther Crumpet")) {
									int dfgdfg = 4564;
								}
							}*/
							obj.process(); //obj.getName()

							// Count action points
							if (obj instanceof SPlayerObject3D) {
								SPlayerObject3D player_obj = (SPlayerObject3D) obj;
								if (player_obj.getAPs() > highest_ap) {
									highest_ap = player_obj.getAPs();
									highest_ap_unit = player_obj;
								}
							}
						}
					}

					// Send AP update?
					if (highest_ap < MAX_ACTION_POINTS) { // Have the action points changed?
						float extra_aps = MAX_ACTION_POINTS - highest_ap;
						giveAPsToAllTroops(extra_aps);
						game.incElapsedTime(extra_aps);
						waiting_for = null;
					} else if (highest_ap_unit.getCurrentController() == null) {
						waiting_for = null;
					} else {
						if (waiting_for != null) {
							if (game.getNoOfPlayersOnSide(waiting_for.side) >= 2) {
								if (highest_ap_unit == waiting_for) {
									if (System.currentTimeMillis() -
											waiting_since >
									MAX_BLOCK_GAME_TIME * 2) {
										this.waiting_for.reduceAPs(
												MAX_ACTION_POINTS /
												2, true);
										S2CCommunication.SendMessage(waiting_for.
												getCurrentController(),
												"Your AP's have been reduced!  Please don't hold up the game!",
												(byte) 2);
										waiting_for = null;
									} else if (System.currentTimeMillis() -
											waiting_since >
									MAX_BLOCK_GAME_TIME) {
										if (sent_holdup_warning == false) {
											S2CCommunication.SendMessage(
													waiting_for.
													getCurrentController(),
													"Hurry up!", (byte) 2);
											sent_holdup_warning = true;
										}
									}
								} else {
									waiting_for = highest_ap_unit;
									waiting_since = System.currentTimeMillis();
									sent_holdup_warning = false;
								}
							}
						}
					}
					map.processSquares();
					game.mission.gameLooped();

					// Count AI threads
					/*if (count_ai_threads.hitInterval()) {
                     //System.out.println("Tot threads: " + AStar.tot_threads);
                      if (AStar.tot_threads > 0) {
                      S2CCommunication.SendAIThinking();
                      }
                      }*/

					game.process();

				} catch (Exception ex) {
					HandleError(ex);
				}
			}

			/*if (send_gameconnect_interval != null) { // It will be null if we're not broadcasting
				if (send_gameconnect_interval.hitInterval()) {
					this.broadcastServer();
				}
			}*/

			long time_taken = System.currentTimeMillis() - start;
			long wait = LOOP_DELAY - time_taken;
			Functions.delay(wait);
			//Thread.yield();
		}
		this.net_server.stopListening();
		this.net_server.closeAll();
		System.exit(0);
	}

	private void giveAPsToAllTroops(float points_to_add) throws IOException {
		for (int o = 0; o < objects.length ; o++) {
			if (objects[o] instanceof SPlayerObject3D) {
				SPlayerObject3D player_obj = (SPlayerObject3D) objects[o];
				player_obj.reduceAPs(-points_to_add, true);
			} else if (objects[o] instanceof SGrenade) {
				SGrenade gren = (SGrenade) objects[o];
				gren.reducePrimeTime(points_to_add);
			}
		}
		game.incElapsedTime(points_to_add);
	}

	public static void IncVPs(byte side, byte amt) {
		game.incVPs(side, amt);
	}

	private void decodeData() {
		try {
			ListIterator it = Server.players.getIterator();
			while (it.hasNext()) {
				SPlayerData pdata = (SPlayerData) it.next();
				ClientConnection conn = pdata.conn;
				if (conn != null) {
					try {
						while (conn.getInput().available() > 0) {
							byte b = conn.getInput().readByte();
							switch (b) {
							case C2SCommunication.KEY_PRESSED:
								C2SCommunication.DecodeKeyPressed(pdata);
								break;
							case C2SCommunication.KEY_RELEASED:
								C2SCommunication.DecodeKeyReleased(pdata);
								break;
							case C2SCommunication.CHANGED_TROOPER:
								C2SCommunication.DecodeChangedTrooper(pdata);
								break;
							case C2SCommunication.ANGLE:
								C2SCommunication.DecodeAngle(pdata);
								break;
							case C2SCommunication.PLAYERS_DATA:
								C2SCommunication.DecodePlayersData(pdata);
								break;
							case C2SCommunication.CHANGED_ITEM:
								C2SCommunication.DecodeChangedItem(pdata);
								break;
							case C2SCommunication.WAIT:
								C2SCommunication.DecodeWait(pdata);
								break;
							case C2SCommunication.AUTOFIRE:
								C2SCommunication.DecodeAutofire(pdata);
								break;
							case C2SCommunication.SHOT_TYPE:
								C2SCommunication.DecodeShotType(pdata);
								break;
							case C2SCommunication.GUARD:
								C2SCommunication.DecodeGuard(pdata);
								break;
							case C2SCommunication.RELOAD:
								C2SCommunication.DecodeReload(pdata);
								break;
							case C2SCommunication.ACTION:
								C2SCommunication.DecodeAction(pdata);
								break;
							case C2SCommunication.USE_ITEM:
								C2SCommunication.DecodeUseItem(pdata);
								break;
							case C2SCommunication.PRIME_AND_THROW:
								C2SCommunication.DecodePrimeAndThrow(pdata);
								break;
								/*case C2SCommunication.BUY_UNIT:
                                 C2SCommunication.DecodeBuyUnit(pdata);
                                 break;*/
								case C2SCommunication.DISCONNECT:
									C2SCommunication.DecodeDisconnect(pdata);
									break;
								case C2SCommunication.PLAYERS_NAME:
									C2SCommunication.DecodePlayersName(pdata);
									break;
								case C2SCommunication.MSG:
									C2SCommunication.DecodeMessage(pdata);
									break;
								case C2SCommunication.PING:
									C2SCommunication.DecodePing(pdata);
									break;
								case C2SCommunication.SELECT_NEXT_UNIT:
									C2SCommunication.DecodeSelectNextUnit(pdata);
									break;
								case C2SCommunication.SELECT_PREV_UNIT:
									C2SCommunication.DecodeSelectPrevUnit(pdata);
									break;
								case C2SCommunication.PLAY_AGAINST_CPU:
									C2SCommunication.DecodePlayAgainstCPU(pdata);
									break;
								case C2SCommunication.SIDE_SELECTED:
									C2SCommunication.DecodePlayersSide(pdata);
									break;
								case C2SCommunication.DESELECT_UNIT:
									C2SCommunication.DecodeDeselectCurrentUnit(pdata);
									break;
								case C2SCommunication.LOCATION:
									C2SCommunication.DecodeUnitsLocation(pdata);
									break;
								case C2SCommunication.OBJECTS_COLLIDED:
									C2SCommunication.DecodeObjectsCollided(pdata);
									break;
								case C2SCommunication.VOTE_SENT:
									C2SCommunication.DecodeVoteSent(pdata);
									break;
								default:
									System.err.println("Unknown data from client: " + b);
								if (conn.getInput().available() > 0) {
									while (conn.getInput().readByte() !=
										C2SCommunication.CHECK) {
										//read more
										System.out.println("Skipping byte");
									}
								}
								break;
							}
						}
					} catch (IOException e) {
						Server.HandleError(e);
						Server.players.removePlayer(pdata);
					}
				}
			}
		} catch (java.util.ConcurrentModificationException ex) {
			System.err.println("Error:" + ex.getMessage());
		}
	}

	public static CollisionMatrix2D getCollisionMatrix() {
		return game.getCollisionMatrix();
	}

	public static void sideHasWon(byte side) {
		game.sideHasWon(side);
	}

	public static void QuitNow() {
		quit_now = true;
	}

	public static void HandleError(Exception ex) {
		System.err.println(new Date().toString());
		System.err.println("Error:" + ex.getMessage());
		if (ex instanceof IOException == false) {
			ex.printStackTrace();
		}
		Functions.LogStackTrace(ex, EXCEPTION_FILE);
	}

}

