/*
 * Created on 02-Oct-2006
 *
 */
package ngrave.server;

import java.util.ArrayList;
import java.util.ListIterator;
import ngrave.server.objects.SPlayerObject3D;

public final class SSideData {

    // If you add anything here, you
    // may need to add them to the reset()
    // function.
    private byte vp=0, side;
    private byte no_of_players_on_side=0;
    private byte no_of_units=0;
    private byte no_of_cpu_units=0;
    public boolean controlled_by_cpu = false; // todo - make private
    private ArrayList ip_log = new ArrayList(); 

    public SSideData(byte side) {
        super();
        this.side = side;
    }

    public void reset() {
        this.vp=0;
        controlled_by_cpu = false;
        no_of_units = 0;
        no_of_cpu_units = 0;
        S2CCommunication.SendVPUpdate(side);
        ip_log.removeAll(ip_log);
    }
    
    public void logIPs() {
        ListIterator players = Server.players.getIterator();
        while (players.hasNext()) {
            SPlayerData player = (SPlayerData) players.next();
            ip_log.add(player.conn.getINetAddress().toString());
        }


    }

    public void incVPs(int amt) {
        if (vp < 100) {
            vp += amt;
            if (vp  > 100) {
                vp = 100;
            }
            S2CCommunication.SendVPUpdate(side);
            if (vp >= 100) {
                Server.sideHasWon(side);
            }
        }
      }

    public byte getVPs() {
        return vp;
    }

    public byte getNoOfPlayers() {
        return no_of_players_on_side;
    }

    public byte getMaxNoOfPlayers() {
        return (byte)(this.no_of_units - this.no_of_cpu_units);
    }

    public void addPlayer() {
    	no_of_players_on_side++;
    }

    public void removePlayer() {
    	no_of_players_on_side--;
    }

    public void addUnit(SPlayerObject3D obj) {
        no_of_units++;
        if (obj.isComputerControlled()) {
            no_of_cpu_units--;
        }
    }

    public void removeUnit(SPlayerObject3D obj) {
        no_of_units--;
        if (obj.isComputerControlled()) {
            no_of_cpu_units--;
        }
    }

    public byte getNoOfUnits() {
        return this.no_of_units;
    }

    public byte getNoOfCPUUnits() {
        return this.no_of_cpu_units;
    }
    
    public void unitIsNowCPU(SPlayerObject3D obj) {
        this.no_of_cpu_units++;
    }

}
