/*
 * Created on 02-Oct-2006
 *
 */
package ngrave.server;

import java.io.IOException;
import java.util.ListIterator;
import java.util.Vector;

public class SPlayers extends Vector {

	private static final long serialVersionUID = 1L;

	public SPlayers() {
        super();
    }

    public String GetPlayersNameByConn(ClientConnection conn) {
        return this.GetPlayerDataByConn(conn).getName();
    }

    public byte GetPlayersSideByConn(ClientConnection conn) {
        return this.GetPlayerDataByConn(conn).side;
    }

    public void setPlayersName(ClientConnection conn, String name) throws IOException {
        this.GetPlayerDataByConn(conn).setName(name);
    }

    public void setPlayersSide(ClientConnection conn, byte side) throws IOException {
        this.GetPlayerDataByConn(conn).side = side;
        Server.game.addPlayerToSide(side);
        Server.frm_log.log("Player joined " + ServerFunctions.getSideName(side));
    }

    public int getNoOfPlayers() {
        return this.size();
    }

    /**
     * This returns the ID of the player
     * @param conn
     * @param side
     * @return
     * @throws IOException
     */
    public void addNewPlayer(ClientConnection conn) throws IOException {
        SPlayerData pdata = new SPlayerData(conn);
        S2CCommunication.SendPlayersOwnID(pdata);
        this.add(pdata);
        Server.frm_log.setNoOfPlayers(this.size());
    }

    public SPlayerData GetPlayerDataByConn(ClientConnection conn) {
        SPlayerData pdata;
        for(byte p=0 ; p<this.size() ; p++) {
            pdata = (SPlayerData)this.get(p);
          if (pdata.conn == conn) {
            return pdata;
          }
        }
        return null;
      }

    public void removePlayer(SPlayerData pdata) {
        if (this.contains(pdata)) { // To stop them being removed twice
            //System.out.println("Player disconnected at " + new Date().toString());
            Server.frm_log.log("Player disconnected from " + pdata.conn.getINetAddress().toString());

            pdata.conn.close();
            Server.game.removePlayerFromSide(pdata.side);
            this.remove(pdata); //must be before we deselectTheCurrentUnit() as this player has probably disconnected already and we don't want to send them any more messages
            Server.frm_log.setNoOfPlayers(this.size());
            pdata.deselectCurrentUnit();
            S2CCommunication.SendMessageToAll(pdata.getName() +
                                              " has disconnected.", (byte) 0);

            // Warn other players if there is no one left on that side.
            if (pdata.side >= 0) {
                if (Server.game.getNoOfPlayersOnSide(pdata.side) == 0 &&
                    Server.game.isControlledByCPU(pdata.side) == false) {
                    S2CCommunication.SendMessageToAll(
                            "Alert!  There are now no players controlling the " +
                            ServerFunctions.getSideName(pdata.side) + "s.",
                            (byte) 2);
                }
            }
        }
    }

    public ListIterator getIterator() {
        return this.listIterator();
    }


}
