package ngrave.server;

import java.io.IOException;

import ngrave.client.Client;
import ngrave.server.S2CCommunication;
import ngrave.server.objects.SPlayerObject3D;


public class SPlayerData {

	public byte side = -1; // default
	private SPlayerObject3D current_unit;
	private final int id;
	public boolean keys[] = new boolean[255];
	public final ClientConnection conn;
	private String name = "Not set";
	private static int next_id=0;

	public SPlayerData(ClientConnection conn) {
		id = next_id++;
		this.conn = conn;
	}

	public void setName(String n) throws IOException {
		System.out.println("Players name is " + n);
		this.name = n;

		// Send it to the other players
		/*if (send_comms) {
          S2CCommunication.SendPlayersName(n, side);
      }*/
	}

	public String getName() {
		return name;
	}

	public int getID() {
		return id;
	}

	public void deselectCurrentUnit() {
		SPlayerObject3D obj = this.current_unit;
		// Tell the unit
		if (obj != null) {
			if (Client.DEBUG) {
				System.out.println("Curr unit is: " + obj.toString() + ".  Now being deselected.");
			}
			obj.setCurrentController(null);
			// Tell us
			this.current_unit = null;
			S2CCommunication.SendDeselectUnit(obj);
		}

	}

	public void selectUnit(SPlayerObject3D unit) {
		if (this.current_unit != unit) {
			if (this.current_unit != null) {
				this.deselectCurrentUnit();
			}
			unit.setCurrentController(this);
			this.current_unit = unit;

			S2CCommunication.SendSelectUnit(this, unit);

		}
	}

	public SPlayerObject3D getCurrentUnit() {
		return this.current_unit;
	}

	public void selectNextUnit() throws IOException {
		int start = 0;
		if (this.current_unit != null) {
			start = this.current_unit.getID()+1;
		}

		boolean found = false;
		for (int u=start ; u < Server.objects.length ; u++) {
			if (Server.objects[u] != null) {
				if (Server.objects[u] instanceof SPlayerObject3D) {
					if (Server.objects[u].side == this.side) {
						SPlayerObject3D unit = (SPlayerObject3D)Server.objects[u];
						if (unit.getCurrentController() == null) {
							found = true;
							this.selectUnit(unit);
							break;
						}
					}
				}
			}
		}

		if (found == false) {
			for (int u=0 ; u < start ; u++) {
				if (Server.objects[u] != null) {
					if (Server.objects[u] instanceof SPlayerObject3D) {
						if (Server.objects[u].side == this.side) {
							SPlayerObject3D unit = (SPlayerObject3D)Server.objects[u];
							if (unit.getCurrentController() == null) {
								found = true;
								this.selectUnit(unit);
								break;
							}
						}
					}
				}
			}
		}
	}

	public void selectPrevUnit() throws IOException {
		int start = Server.objects.length-1;
		if (this.current_unit != null) {
			start = this.current_unit.getID()-1;
		}

		boolean found = false;
		for (int u=start ; u >= 0 ; u--) {
			if (Server.objects[u] != null) {
				if (Server.objects[u] instanceof SPlayerObject3D) {
					if (Server.objects[u].side == this.side) {
						SPlayerObject3D unit = (SPlayerObject3D)Server.objects[u];
						if (unit.getCurrentController() == null) {
							found = true;
							this.selectUnit(unit);
							break;
						}
					}
				}
			}
		}

		if (found == false) {
			for (int u=Server.objects.length-1 ; u >= start ; u--) {
				if (Server.objects[u] != null) {
					if (Server.objects[u] instanceof SPlayerObject3D) {
						if (Server.objects[u].side == this.side) {
							SPlayerObject3D unit = (SPlayerObject3D)Server.objects[u];
							if (unit.getCurrentController() == null) {
								found = true;
								this.selectUnit(unit);
								break;
							}
						}
					}
				}
			}
		}

	}
}
