package ngrave.server;

import java.io.IOException;

public final class SMapSquare {

  // Keep blocking and non-blocking separate
  public static final byte CHAIR_R=-5, CHAIR_F=-4, CHAIR_L=-3, CHAIR_B=-2;
  public static final byte TABLE=-1, FLOOR=1, GRASS=2, OPEN_DOOR=3, EXIT=4;
  public static final byte ROAD=5;
  public static final byte WATER=6, LARGE_WINDOW=7, NOTHING=8;
  public static final byte WINDOW = 35;
  public static final byte CLOSED_DOOR=50, WALL=51, LOCKED_DOOR=52, DEFENDER_COMPUTER=53, ATTACKER_COMPUTER=54;
  public static final byte TREE=55, TRUCK_TRAILER=56;
  public static final byte START_OF_UDF_SQUARES = 98;
  
  private static final int DOOR_CLOSE_TIME = 80;

  public final byte x, z;
  protected final SMapData parent;
  private final byte type;
  private final byte destroyed_type; // what we replace it with if we get destroyed.
  public boolean damaged = false;
  private final boolean processable;
  public final boolean blocks_movement, blocks_targetting_view, blocks_scenery_view;
  
  //Open door data
  private float open_time = Server.game.getElapsedTime();

  public SMapSquare(SMapData map, byte x_pos, byte z_pos, byte square_type, byte destroy_type, boolean process, boolean blocks_move, boolean blocks_targets, boolean blocks_scenery) {
    this.x = x_pos;
    this.z = z_pos;
    parent = map;
    type = square_type;
    this.destroyed_type = destroy_type;
    this.processable = process;
    this.blocks_movement = blocks_move;
    this.blocks_targetting_view = blocks_targets;
    this.blocks_scenery_view = blocks_scenery;
    
    if (x >= 0 && z >= 0) { // If we're creating a dummy wall in getMapSquare(), we use -1, -1.
	    // Remove old square?
	    if (map.getMapSquare(x, z) != null) {
	    	if (map.getMapSquare(x, z).processable) {
	    		map.process_squares.remove(map.getMapSquare(x, z));
	    	}
	    }
	    if (this.processable) {
	    	map.process_squares.add(this);
	    }
    
	    map.setMapSquare(x, z, this);
	    S2CCommunication.SendMapSquareToAll(this);
    }
    
  }
  
  public void process(SMapData map) throws IOException {
  	/*if (Client.DEBUG) {
  		System.out.println("Processing sq " + x + "," + z + " type:" + type);
  	}*/
  	if (this.type == SMapSquare.OPEN_DOOR) {
  		if (this.open_time + DOOR_CLOSE_TIME < Server.game.getElapsedTime()) {
  		  	map.closeDoor(this);
  		}
  	}
  }

  public static void MapSquareFactory(SMapData map, byte x, byte z, byte type) {
      switch (type) {
        case NOTHING:
          new SMapSquare(map,x, z, type, (byte)-1, false, true, false, false);
          break;
        case FLOOR:
          new SMapSquare(map, x, z, type, (byte)-1, false, false, false, false);
          break;
        case WALL:
            new SMapSquare(map, x, z, type, SMapSquare.FLOOR, false, true, true, true);
            break;
        case TRUCK_TRAILER:
            new SMapSquare(map, x, z, type, SMapSquare.FLOOR, false, true, true, false);
            break;
        case GRASS:
          new SMapSquare(map, x, z, type, (byte)-1, false, false, false, false);
          break;
        case ROAD:
            new SMapSquare(map, x, z, type, (byte)-1, false, false, false, false);
            break;
        case WATER:
          new SMapSquare(map, x, z, type, (byte)-1, false, true, false, false);
          break;
        case CLOSED_DOOR:
          new SMapSquare(map, x, z, type, SMapSquare.FLOOR, false, true, true, true);
          break;
        case OPEN_DOOR:
          new SMapSquare(map, x, z, type, (byte)-1, true, false, false, false);
          break;
        case LOCKED_DOOR:
          new SMapSquare(map, x, z, type, SMapSquare.FLOOR, false, true, true, true);
          break;
        case WINDOW:
          new SMapSquare(map, x, z, type, SMapSquare.FLOOR, false, true, false, false);
          break;
        case LARGE_WINDOW:
          new SMapSquare(map, x, z, type, SMapSquare.FLOOR, false, true, false, false);
          break;
        case ATTACKER_COMPUTER:
          new SMapSquare(map, x, z, type, SMapSquare.FLOOR, false, true, true, false);
          break;
        case DEFENDER_COMPUTER:
          new SMapSquare(map, x, z, type, SMapSquare.FLOOR, false, true, true, false);
          break;
        case EXIT:
          new SMapSquare(map, x, z, type, (byte)-1, false, false, false, false);
          break;
        case TREE:
          new SMapSquare(map, x, z, type, SMapSquare.GRASS, false, true, true, false);
          break;
        case TABLE:
          S2CCommunication.SendScenery(S2CCommunication.TABLE, x, z, 0);
          MapSquareFactory(map, x, z, SMapSquare.FLOOR);
          //new SMapSquare(map, x, z, SMapSquare.FLOOR, (byte)-1, false, false, false);
          break;
        case CHAIR_F:
          S2CCommunication.SendScenery(S2CCommunication.CHAIR, x, z, 90);
          MapSquareFactory(map, x, z, SMapSquare.FLOOR);
          //new SMapSquare(map, x, z, SMapSquare.FLOOR, (byte)-1, false, false);
          break;
        case CHAIR_B:
          S2CCommunication.SendScenery(S2CCommunication.CHAIR, x, z, 270);
          MapSquareFactory(map, x, z, SMapSquare.FLOOR);
          //new SMapSquare(map, x, z, SMapSquare.FLOOR, (byte)-1, false, false);
          break;
        case CHAIR_L:
          S2CCommunication.SendScenery(S2CCommunication.CHAIR, x, z, 180);
          MapSquareFactory(map, x, z, SMapSquare.FLOOR);
          //new SMapSquare(map, x, z, SMapSquare.FLOOR, (byte)-1, false, false);
          break;
        case CHAIR_R:
          S2CCommunication.SendScenery(S2CCommunication.CHAIR, x, z, 0);
          MapSquareFactory(map, x, z, SMapSquare.FLOOR);
          //new SMapSquare(map, x, z, SMapSquare.FLOOR, (byte)-1, false, false);
          break;
        default:
          System.out.println("Unknown map square for creation: " + type);
          break;
      }
  }

  public void damage() {
	if (this.destroyed_type >= 0) {
		SMapSquare.MapSquareFactory(Server.map, this.x, this.z, this.destroyed_type);
	}
	SMapSquare new_sq = Server.map.getMapSquare(x, z);
	if (new_sq.damaged == false) {
		new_sq.damaged = true;
  		S2CCommunication.SendMapSquareToAll(new_sq);
  	}
  }
  
  public int getType() {
      return type;
  }

}
