package ngrave.server;

import ssmith.lang.*;
import ssmith.util.Interval;

import java.io.*;
import java.util.ArrayList;

import ngrave.client.Client;
import ngrave.server.objects.SObject;
import ngrave.server.objects.SPlayerObject3D;


public final class SMapData {

  private SMapSquare map[][];
  public int size;
  public ArrayList process_squares = new ArrayList(); // todo - make private
  private Interval process_squares_interval = new Interval(2000);
  private SMapSquare dummy_wall;

  public SMapData(byte size) {
    map = new SMapSquare[size][size];
    this.size = size;

    dummy_wall = new SMapSquare(this, (byte)-1, (byte)-1, SMapSquare.WALL, SMapSquare.WALL, false, true, true, true);
  }

  public void processSquares() throws IOException {
  	if (process_squares_interval.hitInterval()) {
  		try {
            for (int s=0 ; s<this.process_squares.size() ; s++) {
            	SMapSquare sq = (SMapSquare)process_squares.get(s);
            	sq.process(this);
            }
        } catch (IndexOutOfBoundsException ex) {
        	// Probably because a square has been removed
            Server.HandleError(ex);
        }
  	}
  }

  public SMapSquare getMapSquare(float x, float z) {
      return getMapSquare((int)x, (int)z);
  }

  public SMapSquare getMapSquare(int x, int z) {
      try {
          return map[x][z];
        } catch (ArrayIndexOutOfBoundsException ex) {
          return dummy_wall;
        }
  }

  public void setMapSquare(int x, int z, SMapSquare sq) {
      map[x][z] = sq;
  }

  public void openDoor(SMapSquare sq) {
    SMapSquare.MapSquareFactory(this, sq.x, sq.z, SMapSquare.OPEN_DOOR);
  }

  public void closeDoor(SMapSquare sq) {
	 if (Server.getCollisionMatrix().isSquareClear(sq.x, sq.z)) {
	 	SMapSquare.MapSquareFactory(this, sq.x, sq.z, SMapSquare.CLOSED_DOOR);
	 }
  }

  public void turnOffComputer(SPlayerObject3D trooper, SMapSquare sq) {
    if ((sq.getType() == SMapSquare.ATTACKER_COMPUTER && trooper.side == Client.DEFENDER) || (sq.getType() == SMapSquare.DEFENDER_COMPUTER && trooper.side == Client.ATTACKER)) {
        SMapSquare.MapSquareFactory(this, sq.x, sq.z, SMapSquare.WALL);
        S2CCommunication.SendMessageToAll("Computer deactivated!", (byte)1);
      } else {
        S2CCommunication.SendMessage(trooper.getCurrentController(), "That is your own computer.", (byte)0);
      }
    }

  public void removeWalls(SObject centre, double range) {
  		//System.out.println("Centre: " + centre.getX() + "," + centre.getZ() + " range:" + range);
		if (Server.game.mission.wallsCanBeDestroyed()) {
			for (byte z = 0; z < map[0].length; z++) {
				for (byte x = 0; x < map.length; x++) {
					if (map[x][z] != null) {
						if (Functions.distance(x, z, centre.getX(), centre.getZ()) <= range) {
							SMapSquare sq = this.getMapSquare(x, z);
							//System.out.println("Damaging: " + x + "," + z + "(type " + sq.getType() + ")");
							sq.damage();
							//System.out.println("Now type " + this.getMapSquare(x, z).getType());
						}
					}
				}
			}
		}
	}

}
