package ngrave.server;

import ssmith.game.CollisionMatrix2D;
import ssmith.net.*;
import java.io.*;
import java.util.Iterator;
import java.util.ListIterator;

import ngrave.client.C2SCommunication;
import ngrave.client.CItemCarried;
import ngrave.client.CMapData;
import ngrave.client.Client;
import ngrave.client.QuadByte;
import ngrave.client.objects.CBarrel;
import ngrave.client.objects.CBullet;
import ngrave.client.objects.CBulletTrail;
import ngrave.client.objects.CChair;
import ngrave.client.objects.CCorpse;
import ngrave.client.objects.CCorpseRobot;
import ngrave.client.objects.CCorpseTrooper;
import ngrave.client.objects.CCrate;
import ngrave.client.objects.CExplosion;
import ngrave.client.objects.CGrenade;
import ngrave.client.objects.CMapSquare;
import ngrave.client.objects.CObject;
import ngrave.client.objects.CPicture;
import ngrave.client.objects.CPlayerObject3D;
import ngrave.client.objects.CPlayerObjectAlien;
import ngrave.client.objects.CPlayerObjectBattleBot;
import ngrave.client.objects.CPlayerObjectPrisoner;
import ngrave.client.objects.CPlayerObjectRobot;
import ngrave.client.objects.CPlayerObjectSternerRegnix;
import ngrave.client.objects.CPlayerObjectTrooper;
import ngrave.client.objects.CPlayerObjectZeeker;
import ngrave.client.objects.CRocket;
import ngrave.client.objects.CSmoke;
import ngrave.client.objects.CTable;
import ngrave.client.objects.CTestMarker;
import ngrave.missions.Mission;
import ngrave.server.items.SItemCarried;
import ngrave.server.items.SWeaponCarried;
import ngrave.server.objects.SBarrel;
import ngrave.server.objects.SBullet;
import ngrave.server.objects.SBulletTrail;
import ngrave.server.objects.SCrate;
import ngrave.server.objects.SGrenade;
import ngrave.server.objects.SObject;
import ngrave.server.objects.SPlayerObject3D;
import ngrave.server.objects.SPlayerObjectAlien;
import ngrave.server.objects.SPlayerObjectBattleBot;
import ngrave.server.objects.SPlayerObjectPrisoner;
import ngrave.server.objects.SPlayerObjectRobot;
import ngrave.server.objects.SPlayerObjectSternerRegnix;
import ngrave.server.objects.SPlayerObjectTrooper;
import ngrave.server.objects.SPlayerObjectZeeker;
import ngrave.server.objects.SRocket;
import ngrave.server.objects.STestMarker;
import ssmith.awt.PointF;

/**
 * This class contains all the functions for sending data to the client, along with the 
 * corresponding functions to decode it.
 * @author stevec
 *
 */
public final class S2CCommunication {

	// Commands
	public static final byte NEW_OBJECT = -1, UPDATE_OBJECT = 1, REMOVE_OBJECT = 2;
	public static final byte HIGHEST_AP_UPDATE = 3;
	public static final byte APS = 4, MAPSQUARE_CHANGE = 5, VP_UPDATE = 6;
	public static final byte EXPLOSION = 8, WINNER = 9, SMOKE = 10, MSG = 11;
	public static final byte ITEM_LIST = 12;
	public static final byte GAME_DATA = 13, AMMO_LEVEL = 14, REMOVE_ITEM = 15;
	public static final byte NEW_MAP=16, ARMOUR_LEVEL = 17, HEALTH_LEVEL=18;
	public static final byte TROOPER_STATS=19, SCENERY=20, AUTOFIRE = 21;
	public static final byte CAN_SEE_ENEMY = 22, UPDATE_ANGLE=23, TIME_ELAPSED=24;
	public static final byte GUARD=25, ANIMATE_MOVEMENT=27;
	public static final byte PLAYERS_NAME=29, PING_REPLY=30, YOUR_ID_IS=31;
	public static final byte NEW_PLAYER = 32, DESELECT_UNIT=33, SELECT_UNIT=34;
	public static final byte SIDE_OPTIONS = 35, SET_GHOST_MODE=36;
	public static final byte PLAY_SOUND=37, BULLET_MOVEMENT=38, SIDE_IS_CPU_CONTROLLED=39;
	public static final byte SERVER_VERSION=40;
	public static final byte CHECK = 99;

	// Object types
	public static final byte TROOPER = 0, ROBOT = 1, STERNER_REGNIX = 2,
	BULLET = 3, ZEEKER = 4;
	public static final byte PRISONER = 6, BATTLE_BOT = 7, ALIEN = 8,
	GRENADE = 10, ROCKET = 11, MEDIKIT = 12, CHAIR=13, TABLE=14;
	public static final byte CORPSE=15, CRATE=16, BARREL=17;
	public static final byte TROOPER_CORPSE=18, ROBOT_CORPSE=19;
	public static final byte TROOPER_COMMANDER=21, TROOPER_BASE=22, TROOPER_BASIC=23;
	public static final byte TROOPER_HEAVY_SUPPORT=24, TROOPER_SNIPER=25, TROOPER_MEDIC=26;
	public static final byte PICTURE=27, TEST_MARKER=28, BULLET_TRAIL=29;

	private S2CCommunication() { // Don't allow creation
	}

	public static void SendPlayersOwnID(SPlayerData pdata) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending players id.");
		}
		DataOutputStream dos = pdata.conn.getOutput();
		try {
			dos.writeByte(YOUR_ID_IS);
			dos.writeInt(pdata.getID());
			dos.writeByte(CHECK);
			dos.flush();

		} catch (IOException ex) {
			Server.HandleError(ex);
			Server.players.removePlayer(pdata);
		}
	}

	public static void DecodeMyID() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding players id.");
		}
		int id = Client.netClient.getInput().readInt();

		Client.players.getPlayerByID(-1).id = id;

		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode my id.");
		}

		if (Client.SHOW_COMMS) {
			System.out.println("Finished decoding players id.");
		}
		Client.log.addMessage("Decoded unique ID.", 0);
	}

	public static void SendSideOptions(SPlayerData pdata) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending side options.");
		}
		DataOutputStream dos = pdata.conn.getOutput();
		try {
			dos.writeByte(SIDE_OPTIONS);
			dos.writeByte(Server.game.getNoOfPlayersOnSide((byte)0));
			dos.writeByte(Server.game.getMaxNoOfPlayersOnSide((byte)0));
			dos.writeByte(Server.game.getNoOfPlayersOnSide((byte)1));
			dos.writeByte(Server.game.getMaxNoOfPlayersOnSide((byte)1));
			dos.writeByte(CHECK);
			dos.flush();

		} catch (IOException e) {
			Server.HandleError(e);
			Server.players.removePlayer(pdata);
		}
	}

	public static QuadByte DecodeSideOptions() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding side options.");
		}
		DataInputStream dis = Client.netClient.getInput();
		QuadByte qbyte = new QuadByte();
		qbyte.a = dis.readByte();
		qbyte.b = dis.readByte();
		qbyte.c = dis.readByte();
		qbyte.d = dis.readByte();

		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode side options.");
		}
		//frm.setNumbers(a, b, c, d);

		if (Client.SHOW_COMMS) {
			System.out.println("Finished Decoding side options.");
		}
		Client.log.addMessage("Received side options.", 0);

		return qbyte;
	}

	public static void SendNewMap(SPlayerData pdata) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending map.");
		}
		DataOutputStream dos = pdata.conn.getOutput();
		try {
			dos.writeByte(NEW_MAP);
			dos.writeByte(Server.map.size);
			dos.writeByte(CHECK);

			for(int y=0 ; y<Server.map.size ; y++) {
				for(int x=0 ; x<Server.map.size ; x++) {
					SendMapSquare(pdata, Server.map.getMapSquare(x, y));
				}
			}
			dos.flush();

		} catch (IOException e) {
			Server.HandleError(e);
			Server.players.removePlayer(pdata);
		}

	}

	public static void DecodeNewMap() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding map.");
		}
		byte size = Client.netClient.getInput().readByte();
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode new map.");
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished Decoding map.");
		}

		Client.map = new CMapData(size);
		Client.coll_matrix = new CollisionMatrix2D(size, false);
		/*if (Client.DEBUG) {
            System.out.println("Created collision matrix.");
        }*/
		Client.canvas.addObject(Client.map);
		Client.log.addMessage("Received new map.", 0);
	}

	public static void SendGameData(SPlayerData pdata) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending game data.");
		}
		DataOutputStream dos = pdata.conn.getOutput();
		try {
			dos.writeByte(GAME_DATA);
			String mission = Server.game.mission.getClass().getName();
			C2SCommunication.WriteString(dos, mission);
			dos.writeByte(CHECK);
			dos.flush();
		} catch (IOException e) {
			Server.HandleError(e);
			Server.players.removePlayer(pdata);
		}
	}

	public static void DecodeGameData() throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding game data.");
		}
		String mission = C2SCommunication.ReadString(Client.netClient.getInput());
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode game data.");
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished decoding game data.");
		}

		Client.mission = (Mission) Class.forName(mission).newInstance();
		Client.canvas.loadTextures();
		Client.StartNewGame();

		Client.log.addMessage("Mission: " + Client.mission.getMissionTitle(), 1);
		Client.log.addMessage(Client.mission.getMissionBriefing(Client.players.getThisPlayer().side), 0);
		//Client.sfx.playSound(Client.SOUND_DIR + "cybermail.wav");
		Client.mission.setupForClient();

	}

	public static void SendExistingPlayersDetailsToNewPlayer(SPlayerData new_player) {
		if (Client.SHOW_COMMS) {
			System.out.println("SendExistingPlayersDetailsToNewPlayer.");
		}
		Iterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData existing_pdata = (SPlayerData)it.next();
			if (existing_pdata != new_player) {
				SendNewPlayer(new_player, existing_pdata);
			}
		}

	}

	public static void SendNewPlayerToExistingPlayers(SPlayerData new_player_pdata) {
		if (Client.SHOW_COMMS) {
			System.out.println("SendNewPlayerToExistingPlayers.");
		}
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata != new_player_pdata) {
				SendNewPlayer(pdata, new_player_pdata);
			}
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished SendNewPlayerToExistingPlayers.");
		}

	}

	public static void SendNewPlayer(SPlayerData pdata, SPlayerData new_player_pdata) {
		ClientConnection conn = pdata.conn;
		try {
			conn.getOutput().writeByte(NEW_PLAYER);
			conn.getOutput().writeInt(new_player_pdata.getID());
			conn.getOutput().writeByte(new_player_pdata.side);
			C2SCommunication.WriteString(conn.getOutput(), new_player_pdata.getName());
			conn.getOutput().writeByte(CHECK);
			conn.getOutput().flush();
		} catch (IOException e) {
			Server.HandleError(e);
			Server.players.removePlayer(pdata);
		}
	}

	public static void DecodeNewPlayer() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("DecodeNewPlayer.");
		}
		DataInputStream dis = Client.netClient.getInput();
		int id = dis.readInt();
		byte side = dis.readByte();
		String name = C2SCommunication.ReadString(dis);
		byte check = dis.readByte();
		if (check != CHECK) {
			System.err.println("Error on decode new player.");
		}

		Client.players.addPlayer(id, name, side);

		if (Client.SHOW_COMMS) {
			System.out.println("Finished DecodeNewPlayer.");
		}
	}

	public static void SendNewObjectToAll(SObject object) {
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			SendNewObject(pdata, object);
		}
	}
	public static void SendNewObject(SPlayerData pdata, SObject object) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending new object " + object.getID());
		}
		try {
			ClientConnection conn = pdata.conn;
			conn.getOutput().writeByte(NEW_OBJECT);
			if (object instanceof SPlayerObjectTrooper) {
				conn.getOutput().writeByte(TROOPER);
			}
			else if (object instanceof SPlayerObjectRobot) {
				conn.getOutput().writeByte(ROBOT);
			}
			else if (object instanceof SPlayerObjectSternerRegnix) {
				conn.getOutput().writeByte(STERNER_REGNIX);
			}
			else if (object instanceof SPlayerObjectZeeker) {
				conn.getOutput().writeByte(ZEEKER);
			}
			else if (object instanceof SPlayerObjectPrisoner) {
				conn.getOutput().writeByte(PRISONER);
			}
			else if (object instanceof SPlayerObjectBattleBot) {
				conn.getOutput().writeByte(BATTLE_BOT);
			}
			else if (object instanceof SPlayerObjectAlien) {
				conn.getOutput().writeByte(ALIEN);
			}
			else if (object instanceof SBullet) {
				conn.getOutput().writeByte(BULLET);
			}
			else if (object instanceof SBulletTrail) {
				conn.getOutput().writeByte(BULLET_TRAIL);
			}
			else if (object instanceof SRocket) {
				conn.getOutput().writeByte(ROCKET);
			}
			else if (object instanceof SGrenade) {
				conn.getOutput().writeByte(GRENADE);
			}
			else if (object instanceof SCrate) {
				conn.getOutput().writeByte(CRATE);
			}
			else if (object instanceof SBarrel) {
				conn.getOutput().writeByte(BARREL);
			}
			else if (object instanceof STestMarker) {
				conn.getOutput().writeByte(TEST_MARKER);
			}
			else {
				System.err.println("Trying to send unknown object: " + object.toString());
			}
			conn.getOutput().writeInt(object.getID());
			conn.getOutput().writeByte(object.side);
			conn.getOutput().writeFloat(object.getX());
			conn.getOutput().writeFloat(object.getZ());
			conn.getOutput().writeInt(object.getAngle());
			conn.getOutput().writeByte(CHECK);
			conn.getOutput().flush();
		} catch (IOException ex) {
			Server.HandleError(ex);
			Server.players.removePlayer(pdata);
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished sending new object");
		}
	}

	public static void DecodeNewObject(NetworkClient2 client) throws
	IOException {
		CObject obj = null;
		byte type = client.getInput().readByte();
		int no = client.getInput().readInt();
		byte side = client.getInput().readByte();
		float x = client.getInput().readFloat();
		float z = client.getInput().readFloat();
		int y_ang = client.getInput().readInt();
		byte check = client.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode new object, type " + type);
		}

		if (Client.objects != null) {
			if (type == TROOPER) {
				obj = new CPlayerObjectTrooper(no, x, z, y_ang, side);
			}
			else if (type == ROBOT) {
				obj = new CPlayerObjectRobot(no, x, z, y_ang, side);
			}
			else if (type == STERNER_REGNIX) {
				obj = new CPlayerObjectSternerRegnix(no, x, z, y_ang, side);
			}
			else if (type == ZEEKER) {
				obj = new CPlayerObjectZeeker(no, x, z, y_ang, side);
			}
			else if (type == PRISONER) {
				obj = new CPlayerObjectPrisoner(no, x, z, y_ang, side);
			}
			else if (type == BATTLE_BOT) {
				obj = new CPlayerObjectBattleBot(no, x, z, y_ang, side);
			}
			else if (type == ALIEN) {
				obj = new CPlayerObjectAlien(no, x, z, y_ang, side);
			}
			else if (type == BULLET) {
				obj = new CBullet(no, x, z, y_ang, side);
			}
			else if (type == BULLET_TRAIL) {
				obj = new CBulletTrail(no, x, z, y_ang, side);
			}
			else if (type == ROCKET) {
				obj = new CRocket(no, x, z, y_ang, side);
			}
			else if (type == GRENADE) {
				obj = new CGrenade(no, x, z, side);
			}
			else if (type == CRATE) {
				obj = new CCrate(no, x, z);
			}
			else if (type == BARREL) {
				obj = new CBarrel(no, x, z);
			}
			else if (type == TEST_MARKER) {
				obj = new CTestMarker(no, x, z);
			}
			else {
				System.err.println("Trying to decode unknown object:" + type);
			}

			if (Client.SHOW_OBJ_CREATION) {
				System.out.println("Decoding new object " + obj + "(" + no + ")");
			}
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished decoding new object " + no + " - " + obj.toString());
		}
		//return obj;
	}

	public static void SendObjectUpdateToAll(SObject object, boolean force) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending object update for object " + object.getID() + ": " + object.toString());
		}
		DataOutputStream dos;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();

			if (force == false) {
				// Don't send it to the owner!
				if (object instanceof SPlayerObject3D) {
					SPlayerObject3D unit = (SPlayerObject3D)object;
					if (unit.getCurrentController() == pdata) {
						// Don't send it!
						continue;
					}
				}
			}

			dos = pdata.conn.getOutput();
			try {
				dos.writeByte(UPDATE_OBJECT);
				dos.writeInt(object.getID());
				dos.writeFloat(object.getX());
				dos.writeFloat(object.getZ());
				dos.writeByte(CHECK);
				dos.flush();
			} catch (IOException ex) {
				Server.HandleError(ex);
				Server.players.removePlayer(pdata);
			}
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished sending object update");
		}
	}

	public static void DecodeObjectUpdate(NetworkClient2 client) throws
	IOException {
		DataInputStream dis = client.getInput();
		int no = dis.readInt();
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding object update " + no);
		}
		float x = dis.readFloat();
		float z = dis.readFloat();
		byte check = dis.readByte();
		if (check != CHECK) {
			System.err.println("Error on update object.");
		}

		if (Client.objects != null) {
			CObject obj = Client.objects[no];
			if (obj != null) {
				if (Client.SHOW_COMMS) {
					System.out.println("Updating " + obj.toString());
				}
				obj.setLocation(x, z);

				if (obj == Client.camera.getViewer()) {
					Client.map.recalcVisibleSquares(false, false);
				}
			} else {
				System.err.println("Trying to update null object!");
			}
		}
	}

	public static void SendRemoveObject(SObject object, boolean killed) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending remove object " + object.getID());
		}
		ClientConnection conn;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			conn = pdata.conn;
			try {
				conn.getOutput().writeByte(REMOVE_OBJECT);
				conn.getOutput().writeInt(object.getID());
				conn.getOutput().writeByte(CHECK);
				conn.getOutput().flush();
			} catch (IOException ex) {
				Server.HandleError(ex);
				Server.players.removePlayer(pdata);
			}
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished sending remove object");
		}
	}

	public static void DecodeRemoveObject() throws IOException {
		//byte owner2 = Client.client.getInput().readByte();
		int no2 = Client.netClient.getInput().readInt();
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on remove object.");
		}

		if (Client.SHOW_COMMS) {
			System.out.println("Decoding remove object " + no2);
		}
		//boolean killed = Client.client.getInput().readBoolean();
		// Find the object
		if (Client.objects != null) {
			CObject obj = Client.objects[no2];
			if (obj != null) {
				obj.remove();
			} else {
				System.err.println("Trying to remove null object!");
			}
		}
	}

	public static void SendAPs(SPlayerObject3D trooper) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending AP's: " + trooper.getAPs());
		}
		DataOutputStream dos;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata.side == trooper.side) {
				dos = pdata.conn.getOutput();
				try {
					dos.writeByte(APS);
					dos.writeInt(trooper.getID());
					dos.writeFloat(trooper.getAPs());
					dos.writeByte(CHECK);
					dos.flush();
				} catch (IOException ex) {
					Server.HandleError(ex);
					Server.players.removePlayer(pdata);
				}
			}
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished sending AP's");
		}
	}

	public static void DecodeAPs() throws IOException {
		DataInputStream din = Client.netClient.getInput();
		int trooperno = din.readInt();
		float aps = din.readFloat();

		CPlayerObject3D trooper = (CPlayerObject3D) Client.objects[trooperno];
		if (trooper != null) {
			trooper.setAPs(aps);
		} else {
			System.err.println("Trying to give APs to null trooper!");
		}

		byte check = din.readByte();
		if (check != S2CCommunication.CHECK) {
			System.err.println("Error on inc AP's.");
		}

	}

	public static void SendWinner(byte winner) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending Winner.");
		}
		ClientConnection conn;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			conn = pdata.conn;
			try {
				conn.getOutput().writeByte(WINNER);
				conn.getOutput().writeByte(winner);
				conn.getOutput().writeByte(CHECK);
				conn.getOutput().flush();
			} catch (IOException ex) {
				Server.HandleError(ex);
				Server.players.removePlayer(pdata);
			}
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished sending Winner.");
		}
	}

	public static void DecodeWinner() throws IOException {
		byte winner = Client.netClient.getInput().readByte();
		byte check = Client.netClient.getInput().readByte();
		if (check != S2CCommunication.CHECK) {
			System.err.println("Error on decoding winner.");
		}

		Client.sfx.playSound(Statics.SOUND_DIR + "winner.wav");

		if (winner == Client.players.getThisPlayer().side) {
			Client.log.addMessage("*    YOU HAVE WON!!!   *", 2);
			Client.setWinnerText("YOU HAVE WON!");
		} else {
			Client.log.addMessage("*    YOU HAVE LOST!!!  *", 2);
			Client.setWinnerText("YOU HAVE LOST!");
		}
	}

	public static void SendMapSquareToAll(SMapSquare sq) {
		if (Client.SHOW_COMMS) {
			//System.out.println("Sending mapsquare update");
		}
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			SendMapSquare(pdata, sq);
		}
		if (Client.SHOW_COMMS) {
			//System.out.println("Finished sending mapsquare update");
		}
	}

	public static void SendMapSquare(SPlayerData pdata, SMapSquare sq) {
		if (Client.SHOW_COMMS) {
			//System.out.println("Sending mapsquare update");
		}
		try {
			ClientConnection conn = pdata.conn;
			conn.getOutput().writeByte(MAPSQUARE_CHANGE);
			conn.getOutput().writeByte(sq.x);
			conn.getOutput().writeByte(sq.z);
			conn.getOutput().writeByte(sq.getType());
			conn.getOutput().writeBoolean(sq.damaged);
			conn.getOutput().writeBoolean(sq.blocks_movement);
			conn.getOutput().writeBoolean(sq.blocks_targetting_view);
			conn.getOutput().writeBoolean(sq.blocks_scenery_view);
			conn.getOutput().writeByte(CHECK);
		} catch (IOException ex) {
			Server.HandleError(ex);
			Server.players.removePlayer(pdata);
		}

		if (Client.SHOW_COMMS) {
			//System.out.println("Finished sending mapsquare update");
		}
	}

	public static void DecodeMapSquareChange(NetworkClient2 client) throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding mapsquare.");
		}

		byte x = client.getInput().readByte();
		byte z = client.getInput().readByte();
		byte type = client.getInput().readByte();
		boolean damaged = client.getInput().readBoolean();
		boolean blocks_move = client.getInput().readBoolean();
		boolean blocks_targets = client.getInput().readBoolean();
		boolean blocks_scenery = client.getInput().readBoolean();

		byte check = client.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode mapsquare (" + check + ")");
		}

		if (Client.map != null) {
			// Computer turned off?
			CMapSquare sq = Client.map.getMapSquare(x, z);
			if (sq != null) {
				if (sq.type == SMapSquare.ATTACKER_COMPUTER || Client.map.getMapSquare(x, z).type == SMapSquare.DEFENDER_COMPUTER) {
					Client.sfx.playSound(Statics.SOUND_DIR + "deact_computer.wav");
				} else if (sq.type == SMapSquare.OPEN_DOOR || sq.type == SMapSquare.CLOSED_DOOR) {
					Client.sfx.playSound(Statics.SOUND_DIR + "door.wav");
				}
			}

			Client.map.setMapSquareType(x, z, type, damaged, blocks_move, blocks_targets, blocks_scenery);
		}

		if (Client.SHOW_COMMS) {
			System.out.println("Finished Decoding mapsquare.");
		}
	}

	public static void SendVPUpdate(byte side) {
		byte vps = Server.game.getVPs(side);
		if (Client.SHOW_COMMS) {
			System.out.println("Sending VP update side " + side + ", VPs " + vps);
		}
		ClientConnection conn;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			//if (pdata.side == side) {
			conn = pdata.conn;
			try {
				conn.getOutput().writeByte(VP_UPDATE);
				//conn.getOutput().writeInt(pdata.getID());
				conn.getOutput().writeByte(side);
				conn.getOutput().writeByte(vps);
				conn.getOutput().writeByte(CHECK);
				conn.getOutput().flush();
			} catch (IOException ex) {
				Server.HandleError(ex);
				Server.players.removePlayer(pdata);
			}
			//}
		}
	}

	public static void DecodeVPs(NetworkClient2 client) throws
	IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding VP update.");
		}
		byte side = client.getInput().readByte();
		byte vps = client.getInput().readByte();
		byte check = client.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode VPs.");
		}

		if (Client.SHOW_COMMS) {
			System.out.println("Finished Decoding VP update.");
		}

		Client.SetVPs(side, vps);

		/* WE DO THIS IN SETVPS() NOW!
        if (side == Client.players.getThisPlayer().side) {
            Client.log.addMessage("You have " + vps + " Victory Points.", 0);
        } else {
            Client.log.addMessage("Opponent has " + vps + " Victory Points.", 0);
        }*/
	}

	public static void SendExplosion(SObject source, int shards, int size) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending explosion");
		}
		ClientConnection conn;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			conn = pdata.conn;
			try {
				conn.getOutput().writeByte(EXPLOSION);
				conn.getOutput().writeFloat(source.getX());
				conn.getOutput().writeFloat(source.getZ());
				conn.getOutput().writeInt(shards);
				conn.getOutput().writeInt(size);
				conn.getOutput().writeByte(CHECK);
				conn.getOutput().flush();
			} catch (IOException ex) {
				Server.HandleError(ex);
				Server.players.removePlayer(pdata);
			}
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished sending explosion");
		}
	}

	public static void DecodeExplosion() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding explosion.");
		}
		float x = Client.netClient.getInput().readFloat();
		float z = Client.netClient.getInput().readFloat();
		int shards = Client.netClient.getInput().readInt();
		int size = Client.netClient.getInput().readInt();
		//System.err.println("Explosion size " + size);
		CExplosion.ExplosionFactory(x, z, shards, size);
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode explosion.");
		}
	}

	public static void SendMessageToAll(String msg, byte priority) {
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			//try {
			SendMessage(pdata, msg, priority);
			/*} catch (IOException ex) {
                Server.HandleError(ex);
                Server.players.removePlayer(pdata);
            }*/
		}
	}

	public static void SendMessageToAllExcept(SPlayerData except, String msg, byte priority) {
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata != except) {
				SendMessage(pdata, msg, priority);
			}
		}
	}

	public static void SendMessageToAllOnSide(String msg, byte priority, byte side) {
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata.side == side) {
				SendMessage(pdata, msg, priority);
			}
		}
	}

	public static void SendMessage(SPlayerData pdata, String msg, byte priority) {
		if (pdata != null) {
			if (Client.SHOW_COMMS) {
				System.out.println("Sending msg");
			}
			try {
				ClientConnection conn = pdata.conn;
				if (conn != null) {
					conn.getOutput().writeByte(MSG);
					C2SCommunication.WriteString(conn.getOutput(), msg);
					conn.getOutput().writeByte(priority);
					conn.getOutput().writeByte(CHECK);
					conn.getOutput().flush();
				}
			} catch (IOException ex) {
				Server.HandleError(ex);
				Server.players.removePlayer(pdata);
			}
			if (Client.SHOW_COMMS) {
				System.out.println("Finished sending msg");
			}
		}
	}

	public static void DecodeMessage() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding message.");
		}
		String msg = C2SCommunication.ReadString(Client.netClient.getInput());
		byte priority = Client.netClient.getInput().readByte();
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode msg.");
		}
		Client.log.addMessage(msg, priority);
	}

	public static void SendTroopersItemsToAll(SPlayerObject3D obj) {
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			SendTroopersItems(pdata, obj);
		}
	}

	public static void SendTroopersItems(SPlayerData pdata, SPlayerObject3D obj) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending items for trooper " + obj.toString());
		}
		try {
			ClientConnection conn = pdata.conn;
			conn.getOutput().writeByte(ITEM_LIST);
			conn.getOutput().writeInt(obj.getID());
			conn.getOutput().writeByte(obj.getNoOfItemsCarried());
			for (int e = 0; e < obj.getNoOfItemsCarried(); e++) {
				SItemCarried item = (SItemCarried) obj.getItemByPos(e);
				conn.getOutput().writeByte(item.type);
				conn.getOutput().writeInt(item.ref);
				if (item instanceof SWeaponCarried) {
					SWeaponCarried wep = (SWeaponCarried) item;
					conn.getOutput().writeInt(wep.ammo);
				}
				else {
					conn.getOutput().writeInt(1); // Dummy ammo
				}
			}
			conn.getOutput().writeByte(CHECK);
			conn.getOutput().flush();
		} catch (IOException ex) {
			Server.HandleError(ex);
			Server.players.removePlayer(pdata);
		}

	}

	public static void DecodeItemsForTrooper() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding items for trooper.");
		}
		int trooperno = Client.netClient.getInput().readInt();
		byte size = Client.netClient.getInput().readByte();

		CPlayerObject3D trooper = (CPlayerObject3D) Client.objects[trooperno];
		// Clear existing items first
		trooper.removeAllItems();
		for (byte i = 0; i < size; i++) {
			byte type = Client.netClient.getInput().readByte();
			int no = Client.netClient.getInput().readInt();
			int ammo = Client.netClient.getInput().readInt();
			CItemCarried item = new CItemCarried(type, no, ammo);
			if (Client.SHOW_COMMS) {
				System.out.println("New item " + item.name + ".");
			}
			if (trooper != null) {
				trooper.addItem(item);
			} else {
				System.err.println("Trying to give items to null trooper!");
			}
		}

		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode items for trooper.");
		}
	}

	public static void SendAmmoLevel(SPlayerObject3D obj,
			SWeaponCarried weapon) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending ammo level.");
		}
		DataOutputStream dos;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata.side == obj.side) {
				dos = pdata.conn.getOutput();
				try {
					dos.writeByte(AMMO_LEVEL);
					dos.writeInt(obj.getID());
					dos.writeInt(weapon.ref);
					dos.writeInt(weapon.ammo);
					dos.writeByte(CHECK);
					dos.flush();
				} catch (IOException ex) {
					Server.HandleError(ex);
					Server.players.removePlayer(pdata);
				}
			}
		}
	}

	public static void DecodeAmmoLevel() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding ammo level.");
		}
		int trooperno = Client.netClient.getInput().readInt();
		int objno = Client.netClient.getInput().readInt();
		int ammo = Client.netClient.getInput().readInt();
		CPlayerObject3D trooper = (CPlayerObject3D) Client.objects[trooperno];
		if (trooper != null) {
			CItemCarried item = trooper.getItem(objno);
			item.ammo = ammo;
		} else {
			System.err.println("Trying to give ammo to null trooper!");
		}
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode ammo level.");
		}
	}

	public static void SendRemoveItem(SPlayerObject3D obj,
			SItemCarried item) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending remove item.");
		}
		DataOutputStream dos;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata.side == obj.side) {
				dos = pdata.conn.getOutput();
				try {
					dos.writeByte(REMOVE_ITEM);
					dos.writeInt(obj.getID());
					dos.writeInt(item.ref);
					dos.writeByte(CHECK);
					dos.flush();
				} catch (IOException ex) {
					Server.HandleError(ex);
					Server.players.removePlayer(pdata);
				}
			}
		}
	}

	public static void DecodeRemoveItem() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding remove item.");
		}
		int trooperno = Client.netClient.getInput().readInt();
		int objno = Client.netClient.getInput().readInt();
		CPlayerObject3D trooper = (CPlayerObject3D) Client.objects[trooperno];
		if (trooper != null) {
			trooper.removeItem(objno);
		} else {
			System.err.println("Trying to remove item from null trooper!");
		}
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode remove item.");
		}
	}

	public static void SendArmourLevelToAll(SPlayerObject3D obj) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending armour level.");
		}
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata.side == obj.side) {
				SendArmourLevel(pdata, obj);
			}
		}
	}

	public static void SendArmourLevel(SPlayerData pdata, SPlayerObject3D obj) {
		try {
			DataOutputStream dos = pdata.conn.getOutput();
			dos.writeByte(ARMOUR_LEVEL);
			dos.writeInt(obj.getID());
			dos.writeInt(obj.getArmourLevel());
			dos.writeByte(CHECK);
			dos.flush();
		} catch (IOException ex) {
			Server.HandleError(ex);
			Server.players.removePlayer(pdata);
		}

	}

	public static void DecodeArmourLevel() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding armour level.");
		}
		int trooperno = Client.netClient.getInput().readInt();
		int level = Client.netClient.getInput().readInt();
		CPlayerObject3D trooper = (CPlayerObject3D) Client.objects[trooperno];
		if (trooper != null) {
			trooper.armour_damage_reduction = level;
		} else {
			System.err.println("Trying to give armour to null trooper!");
		}
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode ammo level.");
		}
	}

	public static void SendHealthLevelToAll(SPlayerObject3D obj) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending health level.");
		}
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			SendHealthLevel(pdata, obj);
		}
	}

	public static void SendHealthLevel(SPlayerData pdata, SPlayerObject3D obj) {
		try {
			DataOutputStream dos = pdata.conn.getOutput();
			dos.writeByte(HEALTH_LEVEL);
			dos.writeInt(obj.getID());
			dos.writeInt(obj.getHealth());
			dos.writeByte(CHECK);
			dos.flush();
		} catch (IOException ex) {
			Server.HandleError(ex);
			Server.players.removePlayer(pdata);
		}

	}

	public static void DecodeHealthLevel() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding health level.");
		}
		int trooperno = Client.netClient.getInput().readInt();
		int new_health = Client.netClient.getInput().readInt();
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode health level.");
		}

		if (Client.objects != null) {
			CPlayerObject3D trooper = (CPlayerObject3D) Client.objects[trooperno];
			if (trooper != null) {
				trooper.setHealth(new_health);
			} else {
				System.err.println("Trying to remove health from null trooper!");
			}
		}
	}

	public static void SendTrooperStatsToAll(SPlayerObject3D trooper) {
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata.side == trooper.side) {
				SendTrooperStats(pdata, trooper);
			}
		}
	}

	public static void SendTrooperStats(SPlayerData pdata, SPlayerObject3D trooper) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending stats");
		}
		try {
			ClientConnection conn = pdata.conn;
			conn.getOutput().writeByte(TROOPER_STATS);
			conn.getOutput().writeInt(trooper.getID());
			conn.getOutput().writeInt(trooper.name.length());
			conn.getOutput().write(trooper.name.getBytes());
			conn.getOutput().writeInt(trooper.getCombat());
			conn.getOutput().writeFloat(trooper.getAccuracy());
			conn.getOutput().writeByte(CHECK);
			conn.getOutput().flush();
		} catch (IOException ex) {
			Server.HandleError(ex);
			Server.players.removePlayer(pdata);
		}

		if (Client.SHOW_COMMS) {
			System.out.println("Finished sending stats");
		}
	}

	public static void DecodeTrooperStats() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding stats.");
		}
		int objno = Client.netClient.getInput().readInt();
		int len = Client.netClient.getInput().readInt();
		byte b[] = new byte[len];
		while (Client.netClient.getInput().available() < len) {}
		Client.netClient.getInput().read(b);
		int combat = Client.netClient.getInput().readInt();
		float acc = Client.netClient.getInput().readFloat();
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode stats.");
		}

		CPlayerObject3D trooper = (CPlayerObject3D) Client.objects[objno];
		if (trooper != null) {
			trooper.name = new String(b);
			trooper.combat = combat;
			trooper.accuracy = acc;
		} else {
			System.err.println("Trying to give name to null trooper!");
		}

	}

	/**
	 * This is different to the usual SendNewObject in that the scenery object
	 * is never created by the server.
	 */
	public static void SendScenery(byte type, float x, float z, int ang) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending Scenery");
		}
		ClientConnection conn;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			conn = pdata.conn;
			try {
				conn.getOutput().writeByte(SCENERY);
				conn.getOutput().writeByte(type);
				conn.getOutput().writeFloat(x);
				conn.getOutput().writeFloat(z);
				conn.getOutput().writeInt(ang);
				conn.getOutput().writeByte(CHECK);
				conn.getOutput().flush();
			} catch (IOException ex) {
				Server.HandleError(ex);
				Server.players.removePlayer(pdata);
			}
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished sending Scenery");
		}
	}

	public static void DecodeScenery() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding Scenery.");
		}
		byte type = Client.netClient.getInput().readByte();
		float x = Client.netClient.getInput().readFloat();
		float z = Client.netClient.getInput().readFloat();
		int ang = Client.netClient.getInput().readInt();
		switch (type) {
		case SMOKE:
			new CSmoke(x, z);
			break;
		case CHAIR:
			new CChair(x, z, ang);
			break;
		case TABLE:
			new CTable(x, z);
			break;
		case TROOPER_CORPSE:
			new CCorpseTrooper(x, z, ang);
			break;
		case ROBOT_CORPSE:
			new CCorpseRobot(x, z, ang);
			break;
		case CORPSE:
			new CCorpse(x, z, ang);
			break;
		case PICTURE:
			new CPicture();
			break;
		default:
			System.err.println("Unknown scenery for decoding: " + type);
		}
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode Scenery.");
		}
	}

	public static void SendAutofire(SPlayerObject3D trooper) {
		ClientConnection conn;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata.side == trooper.side) {
				conn = pdata.conn;
				try {
					conn.getOutput().writeByte(AUTOFIRE);
					conn.getOutput().writeInt(trooper.getID());
					conn.getOutput().writeBoolean(trooper.getAutofireSetting());
					conn.getOutput().writeByte(CHECK);
					conn.getOutput().flush();
				} catch (IOException ex) {
					Server.HandleError(ex);
					Server.players.removePlayer(pdata);
				}
			}
		}
	}

	public static void DecodeAutofire() throws IOException {
		int trooperno = Client.netClient.getInput().readInt();
		boolean autofire = Client.netClient.getInput().readBoolean();
		CPlayerObject3D trooper = (CPlayerObject3D) Client.objects[trooperno];
		if (trooper != null) {
			trooper.setAutofire(autofire, false);
		} else {
			System.err.println("Trying to decode autofire for null trooper!");
		}
		byte check = Client.netClient.getInput().readByte();
		if (check != S2CCommunication.CHECK) {
			System.err.println("Error on decode autofire.");
		}

	}

	public static void SendCanSeeEnemy(SPlayerObject3D trooper) {
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata.side == trooper.side) {
				DataOutputStream dos = pdata.conn.getOutput();
				try {
					dos.writeByte(CAN_SEE_ENEMY);
					dos.writeInt(trooper.getID());
					dos.writeBoolean(trooper.getCanSeeEnemy());
					dos.writeByte(CHECK);
					dos.flush();
				} catch (IOException ex) {
					Server.HandleError(ex);
					Server.players.removePlayer(pdata);
				}
			}
		}
	}

	public static void DecodeCanSeeEnemy() throws IOException {
		int trooperno = Client.netClient.getInput().readInt();
		boolean can_see = Client.netClient.getInput().readBoolean();
		CPlayerObject3D trooper = (CPlayerObject3D) Client.objects[trooperno];
		if (trooper != null) {
			trooper.setCanSeeEnemy(can_see);
			if (can_see) {
				trooper.setGuard(false, false);
			}
		} else {
			System.err.println("Trying to decode can_see_enemy for null trooper!");
		}
		byte check = Client.netClient.getInput().readByte();
		if (check != S2CCommunication.CHECK) {
			System.err.println("Error on decode can see enemy.");
		}
	}

	public static void SendGuard(SPlayerObject3D trooper) {
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata.side == trooper.side) {
				ClientConnection conn = pdata.conn;
				try {
					conn.getOutput().writeByte(GUARD);
					conn.getOutput().writeInt(trooper.getID());
					conn.getOutput().writeBoolean(trooper.isGuarding());
					conn.getOutput().writeByte(CHECK);
					conn.getOutput().flush();
				} catch (IOException ex) {
					Server.HandleError(ex);
					Server.players.removePlayer(pdata);
				}
			}
		}
	}

	public static void DecodeGuard() throws IOException {
		int trooperno = Client.netClient.getInput().readInt();
		boolean guard = Client.netClient.getInput().readBoolean();
		CPlayerObject3D trooper = (CPlayerObject3D) Client.objects[trooperno];
		if (trooper != null) {
			trooper.setGuard(guard, false);
		} else {
			System.err.println("Trying to decode guard for null trooper!");
		}
		byte check = Client.netClient.getInput().readByte();
		if (check != S2CCommunication.CHECK) {
			System.err.println("Error on decode guard.");
		}

	}

	/**
	 *
	 * @param object
	 * @param force - over-ride not sending it to the object's owner.
	 */
	public static void SendObjectTurnUpdateToAll(SObject object, boolean force) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending object turn update for object "
					+ object.getID() + ": " + object.toString());
		}
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();

			if (force == false) {
				// Don't send it to the owner!
				if (object instanceof SPlayerObject3D) {
					SPlayerObject3D unit = (SPlayerObject3D)object;
					if (unit.getCurrentController() == pdata) {
						// Don't send it!
						continue;
					}
				}
			}

			DataOutputStream dos = pdata.conn.getOutput();
			try {
				dos.writeByte(UPDATE_ANGLE);
				dos.writeInt(object.getID());
				dos.writeInt(object.getAngle());
				dos.writeByte(CHECK);
				dos.flush();
			} catch (IOException ex) {
				Server.HandleError(ex);
				Server.players.removePlayer(pdata);
			}
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished sending object turn update");
		}
	}

	public static void DecodeObjectTurnUpdate(NetworkClient2 client)
	throws IOException {
		int no = client.getInput().readInt();
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding object turn update " + no);
		}
		int y = client.getInput().readInt();
		byte check = client.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode turn object.");
		}

		if (Client.objects != null) {
			CObject obj = Client.objects[no];
			if (obj != null) {
				obj.y_angle = y;
				if (obj == Client.camera.getViewer()) {
					Client.map.recalcVisibleSquares(true, true);
				}
			} else {
				System.err.println("Trying to turn update null object!");
			}
		}
	}

	public static void SendElapsedTime() {
		ClientConnection conn;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			conn = pdata.conn;
			try {
				conn.getOutput().writeByte(TIME_ELAPSED);
				conn.getOutput().writeInt((int) Server.game.getElapsedTime());
				conn.getOutput().writeByte(CHECK);
				conn.getOutput().flush();
			} catch (IOException ex) {
				Server.HandleError(ex);
				Server.players.removePlayer(pdata);
			}
		}
	}

	public static void DecodeElapsedTime() throws IOException {
		Client.setElapsedTime(Client.netClient.getInput().readInt());
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode new map.");
		}
	}

	public static void SendAnimate(SObject object) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending animate for object "
					+ object.getID() + ": " + object.toString());
		}
		DataOutputStream dos;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			dos = pdata.conn.getOutput();
			try {
				dos.writeByte(ANIMATE_MOVEMENT);
				dos.writeInt(object.getID());
				dos.writeByte(CHECK);
				dos.flush();
			} catch (IOException ex) {
				Server.HandleError(ex);
				Server.players.removePlayer(pdata);
			}
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished sending object animate");
		}
	}

	public static void DecodeAnimate(NetworkClient2 client)
	throws IOException {
		int no = client.getInput().readInt();
		byte check = client.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode turn object.");
		}

		if (Client.SHOW_COMMS) {
			System.out.println("Decoding animate object no " + no);
		}

		if (Client.objects != null) {
			CObject obj = Client.objects[no];
			if (obj != null) {
				obj.animateMovement();
			} else {
				System.err.println("Trying to animate null object!");
			}
		}
	}

	public static void SendPlayersNameToAll(String name, byte id) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending name");
		}
		ClientConnection conn;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata.getID() != id) {
				conn = pdata.conn;
				try {
					conn.getOutput().writeByte(PLAYERS_NAME);
					conn.getOutput().writeInt(id);
					conn.getOutput().writeInt(name.length());
					conn.getOutput().write(name.getBytes());
					conn.getOutput().writeByte(CHECK);
					conn.getOutput().flush();
				} catch (IOException ex) {
					Server.HandleError(ex);
					Server.players.removePlayer(pdata);
				}
			}
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished sending msg");
		}
	}

	public static void DecodePlayersName() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding name.");
		}
		int id = Client.netClient.getInput().readInt();
		int len = Client.netClient.getInput().readInt();
		byte b[] = new byte[len];
		while (Client.netClient.getInput().available() < len) {}
		Client.netClient.getInput().read(b);
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode name.");
		}
		String name = new String(b);
		Client.players.getPlayerByID(id).setName(name);
		Client.log.addMessage(name + " has joined.", (byte)0);

	}

	public static void SendPingReply(SPlayerData pdata) {
		try {
			pdata.conn.getOutput().writeByte(PING_REPLY);
			pdata.conn.getOutput().flush();
		} catch (IOException e) {
			Server.HandleError(e);
			Server.players.removePlayer(pdata);
		}
	}

	public static void DecodePingReply() {
		Client.ping_test.pingReceived();
	}

	public static void SendDeselectUnit(SPlayerObject3D obj) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending deselect unit to clients");
		}
		DataOutputStream dos;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata.side == obj.side) {
				dos = pdata.conn.getOutput();
				try {
					dos.writeByte(DESELECT_UNIT);
					dos.writeInt(obj.getID());
					dos.writeByte(CHECK);
					dos.flush();
				} catch (IOException ex) {
					Server.HandleError(ex);
					Server.players.removePlayer(pdata);
				}
			}
		}
	}

	public static void DecodeDeselectUnit() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Decoding deselect unit from server");
		}
		int trooperno = Client.netClient.getInput().readInt();
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on deselect unit.");
		}

		if (Client.objects != null) {
			CPlayerObject3D trooper = (CPlayerObject3D) Client.objects[trooperno];
			if (trooper != null) {
				if (Client.current_unit == trooper) {
					Client.current_unit = null;
				}
				trooper.setCurrentController(null);
			} else {
				System.err.println("Trying to deselect null trooper!");
			}
		}
	}

	public static void SendSelectUnit(SPlayerData player, SPlayerObject3D obj) {
		if (Client.SHOW_COMMS) {
			System.out.println("Server: Sending select unit");
		}
		DataOutputStream dos;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			if (pdata.side == obj.side) {
				dos = pdata.conn.getOutput();
				try {
					dos.writeByte(SELECT_UNIT);
					dos.writeInt(player.getID());
					dos.writeInt(obj.getID());
					dos.writeByte(CHECK);
					dos.flush();
				} catch (IOException ex) {
					Server.HandleError(ex);
					Server.players.removePlayer(pdata);
				}
			}
		}
	}

	public static void DecodeSelectUnit() throws IOException {
		if (Client.SHOW_COMMS) {
			System.out.println("Client: Decoding select unit");
		}
		int playerid = Client.netClient.getInput().readInt();
		int trooperid = Client.netClient.getInput().readInt();
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on select unit.");
		}

		CPlayerObject3D trooper = (CPlayerObject3D) Client.objects[trooperid];
		if (trooper != null) {
			trooper.setCurrentController(Client.players.getPlayerByID(playerid));
		} else {
			System.err.println("Trying to select null trooper!");
		}
	}

	public static void SendSetGhostMode(SPlayerData pdata) {
		DataOutputStream dos = pdata.conn.getOutput();
		try {
			dos.writeByte(SET_GHOST_MODE);
			dos.writeByte(CHECK);
			dos.flush();
		} catch (IOException ex) {
			Server.HandleError(ex);
			Server.players.removePlayer(pdata);
		}
	}

	public static void DecodeSetGhostMode() throws IOException {
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on set ghost mode.");
		}
		Client.setGhostMode(true);

	}

	public static void SendPlaySound(SPlayerData pdata, int sound) {
		DataOutputStream dos = pdata.conn.getOutput();
		try {
			dos.writeByte(PLAY_SOUND);
			dos.writeInt(sound);
			dos.writeByte(CHECK);
			dos.flush();
		} catch (IOException ex) {
			Server.HandleError(ex);
			Server.players.removePlayer(pdata);
		}
	}

	public static void DecodePlaySound() throws IOException {
		int sound = Client.netClient.getInput().readInt();
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on play sound.");
		}

		// todo
	}

	public static void SendBulletMovement(SObject object, PointF start, PointF finish, float speed) {
		if (Client.SHOW_COMMS) {
			System.out.println("Sending bullet movement for object " + object.getID() + ": " + object.toString());
		}
		DataOutputStream dos;
		ListIterator it = Server.players.getIterator();
		while (it.hasNext()) {
			SPlayerData pdata = (SPlayerData)it.next();
			dos = pdata.conn.getOutput();
			try {
				dos.writeByte(BULLET_MOVEMENT);
				dos.writeInt(object.getID());
				dos.writeFloat(start.x);
				dos.writeFloat(start.y);
				dos.writeFloat(finish.x);
				dos.writeFloat(finish.y);
				dos.writeFloat(speed);
				dos.writeByte(CHECK);
				dos.flush();
			} catch (IOException ex) {
				Server.players.removePlayer(pdata);
				Server.HandleError(ex);
			}
		}
		if (Client.SHOW_COMMS) {
			System.out.println("Finished sending bullet movement");
		}
	}

	public static void DecodeBulletMovement(NetworkClient2 client) throws
	IOException {
		DataInputStream dis = client.getInput();
		int no = dis.readInt();
		float start_x = dis.readFloat();
		float start_z = dis.readFloat();
		float end_x = dis.readFloat();
		float end_z = dis.readFloat();
		float speed = dis.readFloat();
		byte check = dis.readByte();
		if (check != CHECK) {
			System.err.println("Error on decode bullet movement.");
		}

		CObject obj = Client.objects[no];
		if (obj != null) {
			// todo
		} else {
			System.err.println("Trying to update null object!");
		}

	}

	public static void SendSideIsCPUControlled(SPlayerData pdata, byte side) {
		DataOutputStream dos = pdata.conn.getOutput();
		try {
			dos.writeByte(SIDE_IS_CPU_CONTROLLED);
			dos.writeByte(side);
			dos.writeByte(CHECK);
			dos.flush();
		} catch (IOException ex) {
			Server.HandleError(ex);
			Server.players.removePlayer(pdata);
		}
	}

	public static void DecodeSideIsCPUControlled() throws IOException {
		byte side = Client.netClient.getInput().readByte();
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode cpu controlled.");
		}

		// todo
	}

	public static void SendServerVersion(SPlayerData pdata) {
		DataOutputStream dos = pdata.conn.getOutput();
		try {
			dos.writeByte(SERVER_VERSION);
			dos.writeFloat(Client.VERSION);
			dos.writeByte(CHECK);
			dos.flush();
		} catch (IOException ex) {
			Server.HandleError(ex);
			Server.players.removePlayer(pdata);
		}
	}

	public static void DecodeServerVersion() throws IOException {
		float version = Client.netClient.getInput().readFloat();
		byte check = Client.netClient.getInput().readByte();
		if (check != CHECK) {
			System.err.println("Error on decode server version.");
		}

		// todo
	}

}
