package ngrave.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import ngrave.client.C2SCommunication;

/**
 * DO NOT EDIT THIS FILE
 * IT IS A COPY OF THE FILE IN GAMECONNECTOR()
 *
 */

public class GameDetails {

	public String game_name, server_name, ip, misc_details;
	public int port, ping_time;
	public float version;
	public byte tot_players, max_players, ai_side;
	public long last_notice_time;
	private int c_version;

	public GameDetails(int ver) {
		super();
		this.c_version = ver;
		last_notice_time = System.currentTimeMillis();
	}

	public GameDetails(int c_ver, String gname, String sname, String ip, int port, byte tot, byte max, String misc, int ping, float ver, byte ai_s) {
		this(c_ver);

		this.game_name = gname;
		this.server_name = sname;
		this.ip = ip;
		this.port = port;
		this.tot_players = tot;
		this.max_players = max;
		this.misc_details = misc;
		this.ping_time = ping;
		this.version = ver;
		this.ai_side = ai_s;
	}

	public void read(DataInputStream dis) throws IOException {
		game_name = C2SCommunication.ReadString(dis);
		server_name = C2SCommunication.ReadString(dis);
		ip = C2SCommunication.ReadString(dis);
		port = dis.readInt();
		tot_players = dis.readByte();
		max_players = dis.readByte();
		ping_time = dis.readInt();
		this.version = dis.readFloat();
		ai_side = dis.readByte();
		misc_details = C2SCommunication.ReadString(dis);
	}

	public void write(DataOutputStream dos) throws IOException {
		C2SCommunication.WriteString(dos, game_name);
		C2SCommunication.WriteString(dos, server_name);
		C2SCommunication.WriteString(dos, ip);
		dos.writeInt(port);
		dos.writeByte(tot_players);
		dos.writeByte(max_players);
		dos.writeInt(ping_time);
		dos.writeFloat(this.version);
		dos.writeByte(ai_side);
		C2SCommunication.WriteString(dos, misc_details);
	}

/*	public static synchronized void WriteString(DataOutputStream dos, String str) throws IOException {
		dos.writeInt(str.length());
		dos.write(str.getBytes());
	}

	public static synchronized String ReadString(DataInputStream dis) throws IOException {
		int len = dis.readInt();
		if (len < C2SCommunication.MAX_STRING_LENGTH) {
		byte b[] = new byte[len];
		while (dis.available() < len) {
			Functions.delay(100);
		}
		dis.read(b);
		return new String(b);
		} else {
			throw new IOException("String too long (" + len + ")");
		}
	}
*/
}
