/*
 * Created on Sep 30, 2005
 *
 */
package ngrave.server;

import ngrave.server.objects.SObject;

/**
 * @author Stephen Smith
 *
 */
public class CollisionDetails {
	
	private boolean blocked_by_scenery;
	private SObject blocking_object;

	/**
	 * 
	 */
	public CollisionDetails() {
		super();
		reset();
	}
	
	public void reset() {
		this.blocked_by_scenery = false;
		this.blocking_object = null;
	}
	
	public boolean moveSuccessful() {
		return this.blocked_by_scenery == false && this.blockedByObject() == false;
	}
	
	public boolean blockedByScenery() {
		return this.blocked_by_scenery;
	}

	public boolean blockedByObject() {
		return this.blocking_object != null;
	}

	public void setBlockedByScenery() {
		this.blocked_by_scenery = true;
	}

	public void setBlockedByObject(SObject blocker) {
		this.blocking_object = blocker;
	}
	
	public SObject getBlockingObject() {
		return this.blocking_object;
	}

}
