/*
 * Created on 02-Oct-2006
 *
 */
package ngrave.server;

import java.io.IOException;
import java.net.Socket;
import java.util.Iterator;
import ssmith.net.NetworkMultiServer2;
import ssmith.net.NetworkMultiServerConn2;
import ngrave.client.C2SCommunication;
import ngrave.exceptions.HackerException;

public class ClientConnection extends NetworkMultiServerConn2 {

	public ClientConnection(NetworkMultiServer2 svr, Socket sck) throws IOException {
		super(svr, sck);
		sck.setSoTimeout(10000); // 10 seconds
		//System.out.println("Player connected at " + new Date().toString());
		Server.frm_log.log("Player connected from " + this.getINetAddress().toString());

		if (!Statics.MUTE) {
			Server.sfx.playSound(Statics.SOUND_DIR + "msg.wav");
		}

		// Check connection string
		String str = C2SCommunication.ReadString(this.getInput());
		if (str.equalsIgnoreCase(Statics.CONNECTION_STRING)) {
			Iterator it = Server.players.getIterator();
			while (it.hasNext()) {
				SPlayerData pdata = (SPlayerData)it.next();
				System.out.println("Checking player: " + pdata.conn.getINetAddress().toString());
				if (pdata.conn.sck.getRemoteSocketAddress().toString().equalsIgnoreCase(sck.getRemoteSocketAddress().toString())) {
					/*S2CCommunication.SendMessage(this, "You are already connected.  Only one connection at a time is allowed.", (byte)2);
                this.close();
                return;*/
					Server.frm_log.log("Warning - player seems to be already connected.");
					break;
				}
			}

			Server.players.addNewPlayer(this); // This must be at the end so we don't start sending bytes in two threads!
			return;
		} else {
			// Some hacker?
			Server.frm_log.log("Hacker");
			this.close();
			throw new HackerException();
		}
	}

}
