package ngrave.missions;

import ssmith.io.TextFile;
import ssmith.util.*;
import ssmith.astar.WayPoints;
import ssmith.lang.Functions;
import java.awt.Point;
import java.io.IOException;

import ngrave.ai.GuardAI;
import ngrave.ai.HuntForAI;
import ngrave.ai.HuntForAIGroup;
import ngrave.ai.Wander90AI;
import ngrave.client.Client;
import ngrave.client.TexLoader;
import ngrave.client.objects.CPlanet;
import ngrave.client.objects.CStarfield;
import ngrave.server.S2CCommunication;
import ngrave.server.SMapData;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.items.SGrenadeCarried;
import ngrave.server.items.SWeaponCarried;
import ngrave.server.objects.SCrate;
import ngrave.server.objects.SPlayerObject3D;
import ngrave.server.objects.SPlayerObjectRobot;
import ngrave.server.objects.SPlayerObjectSternerRegnix;
import ngrave.server.objects.SPlayerObjectTrooper;

public final class TheAssassins
extends Mission {

	private byte VPS_PER_ATTACKER_KILLED;

	private WayPoints attacker_start_positions = new WayPoints();
	private WayPoints robot_start_positions = new WayPoints();
	private WayPoints sterner_start_positions = new WayPoints();

	private SPlayerObject3D sterner;
	private WayPoints look_in_locations;

	public String getMissionTitle() {
		return "The Assassins";
	}

	public boolean randomMap() {
		return false;
	}

	public int getNoOfPlayers() {
		return 2;
	}

	public String getMissionBriefing(byte side) {
		switch(side) {
		case 0:
			return "You must kill Sterner Regnix!  He is the green one, hidden somewhere inside the building.";//  You have "+this.getMaxTime() + " seconds to finish the job.";
		case 1:
			return "You must protect Sterner Regnix and kill all the attackers.";//  You have "+this.getMaxTime() + " seconds to evade them.";
		default:
			return "";
		}
	}

	public int getCredits(byte side) {
		switch (side) {
		case 0:
			return 175;
		default:
			return 60;
		}
	}

	public boolean wallsCanBeDestroyed() {
		return true;
	}

	public void setupForClient() {
		new CPlanet();
		new CStarfield();
	}

	public int getMaxTime() {
		return 2000;
	}

	public void timeExpired() {
		Server.IncVPs(Client.DEFENDER, (byte)100);
	}

	public void setupForServer() {
		look_in_locations = new WayPoints();

		TextFile tf = new TextFile();
		try {
			tf.openFile(Client.MISSION_DIR + "theassassins.csv", TextFile.READ);
			CSVString line = new CSVString(tf.readLine());
			byte size = new Byte(line.getFirstSection()).byteValue();
			Server.map = new SMapData(size);
			for (byte z = 0; z < size; z++) {
				line = new CSVString(tf.readLine());
				//System.out.println(line.toString());
				for (byte x = 0; x < size; x++) {
					byte b = new Byte(line.getSection(x)).byteValue();
					if (b == 99) {
						this.sterner_start_positions.add(x, z);
						look_in_locations.add(x, z);
						b = SMapSquare.FLOOR;
					}
					else if (b == 98) {
						this.robot_start_positions.add(x, z);
						b = SMapSquare.FLOOR;
					}
					else if (b == 97) {
						this.attacker_start_positions.add(x, z);
						b = SMapSquare.GRASS;
					}
					SMapSquare.MapSquareFactory(Server.map, x, z, b);
				}
			}
			tf.close();
		} catch (IOException e) {
			Server.HandleError(e);
		}

		// Place crates
		int crates = 4;
		while (crates > 0) {
			int x = Functions.rnd(5, Server.map.size -5);
			int z = Functions.rnd(5, Server.map.size -5);
			if (Server.map.getMapSquare(x, z).getType() == SMapSquare.FLOOR) {
				new SCrate(x+0.5f, z+0.5f);
				crates--;
			}
		}

		// Place pictures
		for(int b=0 ; b<5 ; b++) {
			S2CCommunication.SendScenery(S2CCommunication.PICTURE, 0f, 0f, 0);
		}

		// Create troops
		int no_of_attackers = 5;
		/*if (ServerFunctions.GetPlayerDataForSide(Client.ATTACKER).isCPU() == true) {
       no_of_attackers = 8;
       }*/
		VPS_PER_ATTACKER_KILLED = (byte)((101 / no_of_attackers) + 1);
		SPlayerObject3D trooper = null;
		for(int q=0 ; q<no_of_attackers ; q++) {
			Point p = attacker_start_positions.getRandomPoint();
			attacker_start_positions.remove(p);
			trooper = new SPlayerObjectTrooper(Client.ATTACKER, p.x + 0.5f, p.y + 0.5f);
			//if (Server.default_equipment || trooper.computer_controlled) {
			if (trooper.hasAnyItems() == false) {
				trooper.addItem(new SWeaponCarried(SWeaponCarried.LASER_RIFLE));
				trooper.addItem(new SGrenadeCarried()); // Required for Rescue from the mines!
				trooper.setArmour(18);
			}
			//}
		}

		int no_of_defenders = 5;
		for(int q=0 ; q<no_of_defenders ; q++) {
			Point p = robot_start_positions.getRandomPoint();
			robot_start_positions.remove(p);
			new SPlayerObjectRobot(Client.DEFENDER, p.x + 0.5f, p.y + 0.5f);
		}

		Point p = sterner_start_positions.getRandomPoint();
		sterner_start_positions.remove(p);
		sterner = new SPlayerObjectSternerRegnix(Client.DEFENDER, p.x + 0.5f, p.y + 0.5f);

	}

	public void gameLooped() {
	}

	public String getOuterWallTexture() {
		return "metal5.png";
	}

	public String getInnerFloorTexture() {
		return "floor02.png";
	}

	public String getDamagedInnerFloorTexture() {
		return "damaged_floor02.png";
	}

	public String getOuterFloorTexture() {
		return "grass.png";
	}

	public String getDamagedOuterFloorTexture() {
		return "damaged_grass.png";
	}

	public String getDoorTexture() {
		return "door11.png";
	}

	public String getRoadTexture() {
		return "road1.png";
	}

	public String getDamagedRoadTexture() {
		return "damaged_road1.png";
	}

	public String getStarfieldTexture() {
		return "mineral5.png";
	}

	public String getCeilingTexture() {
		return "beige012.png";
	}

	public String getDamagedCeilingTexture() {
		return "damaged_beige012.png";
	}

	public String getLockedDoorTexture() {
		return "";
	}

	public String getExitTexture() {
		return "";
	}

	public void trooperKilled(SPlayerObject3D trooper) {
		if (trooper instanceof SPlayerObjectSternerRegnix) {
			Server.IncVPs(Client.ATTACKER, (byte)100);
		} else if (trooper.side == Client.ATTACKER) {
			Server.IncVPs(Client.DEFENDER, VPS_PER_ATTACKER_KILLED);
		}
	}

	public String getDescription() {
		return "The attackers must assassinate Sterner Regnix, whilst the defenders must protect him.  One-player note - the AI for both sides is intelligent.";
	}

	public String getPictureTexture(int no) {
		if (no == TexLoader.POSTER1) {
			return "pic_ls_ta1.png";
		} else if (no == TexLoader.POSTER2) {
			return "pic_kelly_kebab.png";
		} else if (no == TexLoader.POSTER3) {
			return "pic_kel_mirror.png";
		} else if (no == TexLoader.POSTER4) {
			return "pic_kel_mirror.png";
		} else {
			System.err.println("Too high pic no!");
			return "";
		}
	}

	public boolean setupAI(byte side) {
		// AI
		SPlayerObject3D trooper;

		// If the attackers are CPU controlled, tell them to look
		// for Sterner Regnix.
		HuntForAIGroup hunt_group = new HuntForAIGroup(sterner, look_in_locations);
		for(int o=0 ; o<Server.objects.length ; o++) {
			if (Server.objects[o] != null) {
				if (Server.objects[o] instanceof SPlayerObject3D) {
					trooper = (SPlayerObject3D) Server.objects[o];
					if (trooper.side == side) {
						if (trooper.isComputerControlled() == false) {
							if (trooper.side == Client.ATTACKER) {
								trooper.setAI(new HuntForAI(trooper, hunt_group));
							} else if (trooper.side == Client.DEFENDER) {
								if (Functions.rnd(0, 1) == 1 && trooper instanceof SPlayerObjectSternerRegnix == false) {
									trooper.setAI(new Wander90AI(trooper));
								} else {
									trooper.setAI(new GuardAI(trooper));
								}
							}
						}
					}
				}
			}
		}
		return true;

	}

}
